/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class NumericalCombinator
extends AppliesToProcessor {
    public static final int MAX_OPERATIONS = 1000;
    public static final ProcessorMeta<NumericalCombinator, Parameter> META = new ProcessorMeta<NumericalCombinator, Parameter>(){

        @Override
        public String getName() {
            return "NumericalCombinator";
        }

        @Override
        public String getDocPage() {
            return "numerical-combinations";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.ENRICH, ProcessorTag.MATH});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION", 1.actionVerb("Generate") + " numerical combinations")).withBoolDefaultTrue("add", this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.ADD", "+"), this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.ADD.TOOLTIP", "Generate additions")).withBoolDefaultTrue("sub", this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.SUB", "-"), this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.SUB.TOOLTIP", "Generate subtractions")).withBoolDefaultTrue("mul", this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.MUL", "\u00d7"), this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.MUL.TOOLTIP", "Generate multiplications")).withBoolDefaultTrue("div", this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.DIV", "\u00f7"), this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.DIV.TOOLTIP", "Generate divisions")).withMandSParam("prefix", this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.DESCRIPTION.PREFIX", "Columns prefix"));
        }

        @Override
        public Object selfReport(Parameter param) {
            JsonObject out = AppliesToProcessor.selfReport(param);
            out.remove("prefix");
            return out;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.NumericalCombinator.HELP", "This processor combine every pair of numerical columns with standard `+` `-` `\u00d7` `\u00f7` operations.\n\nOperations on empty cells and division by 0 yield empty cells.");
        }

        @Override
        public NumericalCombinator build(Parameter parameter) throws Exception {
            return new NumericalCombinator(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter numericalCombinatorParam = (Parameter)pss.params;
            if (numericalCombinatorParam.columns == null || numericalCombinatorParam.columns.isEmpty()) {
                throw new IllegalConfigurationException("Missing columns information for lineage on the mean processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                if (numericalCombinatorParam.columns.size() >= 20) {
                    throw new IllegalArgumentException("Too many columns on the NumericalCombinator processor (max 19).");
                }
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Set<Operator> ops = numericalCombinatorParam.getOperators();
                for (int i = 0; i < numericalCombinatorParam.columns.size() - 1; ++i) {
                    for (int j = i + 1; j < numericalCombinatorParam.columns.size(); ++j) {
                        String leftColumn = (String)numericalCombinatorParam.columns.get(i);
                        String rightColumn = (String)numericalCombinatorParam.columns.get(j);
                        ops.forEach(operator -> this.addColumnRelationsForOperator(numericalCombinatorParam, updatedDatasetPairLineage, (Operator)((Object)((Object)operator)), leftColumn, rightColumn));
                    }
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }

        private void addColumnRelationsForOperator(Parameter numericalCombinatorParam, DatasetPairLineage updatedDatasetPairLineage, Operator operator, String leftColumn, String rightColumn) {
            String output = numericalCombinatorParam.prefix + operator.getPrefix() + leftColumn + "_" + rightColumn;
            updatedDatasetPairLineage.removeRelationsOnColumn(output);
            updatedDatasetPairLineage.addFactorizedColumnRelations(leftColumn, output);
            updatedDatasetPairLineage.addFactorizedColumnRelations(rightColumn, output);
        }
    };
    private static final long[] FACTORIAL_PRE = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private final Parameter parameter;
    private List<Operation> operations;
    private Set<Operator> operators;
    private Set<String> outputCols = new HashSet<String>();

    public NumericalCombinator(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void columnsUpdated() {
        if (this.operators == null) {
            this.operators = this.parameter.getOperators();
            if (this.operators.isEmpty()) {
                throw new IllegalArgumentException("Please select at least 1 operation.");
            }
        }
        ColumnFactory cf = this.getColumnFactory();
        ArrayList<String> inputCols = new ArrayList<String>();
        for (Column col : this.columns) {
            if (this.outputCols.contains(col.getName())) continue;
            inputCols.add(col.getName());
        }
        int n = inputCols.size();
        if (n < 2) {
            this.operations = new ArrayList<Operation>();
            return;
        }
        if (n >= 20) {
            throw new IllegalArgumentException("Too many columns (max 19).");
        }
        int opCount = (int)(FACTORIAL_PRE[n] / (2L * FACTORIAL_PRE[n - 2])) * this.operators.size();
        if (opCount > 1000) {
            throw new IllegalArgumentException("Too many combinations.");
        }
        this.operations = new ArrayList<Operation>(opCount);
        for (int i = 0; i < n - 1; ++i) {
            String lc = (String)inputCols.get(i);
            for (int j = i + 1; j < n; ++j) {
                String rc = (String)inputCols.get(j);
                for (Operator op : this.operators) {
                    String vc = this.parameter.prefix + op.getPrefix() + lc + "_" + rc;
                    this.operations.add(new Operation(cf.column(lc, Processor.ProcessorRole.INPUT_COLUMN), cf.column(rc, Processor.ProcessorRole.INPUT_COLUMN), cf.column(vc, Processor.ProcessorRole.OUTPUT_COLUMN), op));
                    this.outputCols.add(vc);
                }
            }
        }
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
        for (Operation operation : this.operations) {
            operation.compute(row);
        }
    }

    public void postProcess() throws Exception {
    }

    @Override
    public Parameter getParams() {
        return this.parameter;
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public String prefix = "";
        public boolean add = true;
        public boolean sub = true;
        public boolean mul = true;
        public boolean div = true;

        public Parameter() {
            if (this.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN) {
                this.appliesTo = AppliesToProcessor.AppliesTo.COLUMNS;
            }
        }

        @Transient
        public Set<Operator> getOperators() {
            LinkedHashSet<Operator> ops = new LinkedHashSet<Operator>(4);
            if (this.add) {
                ops.add(Operator.ADD);
            }
            if (this.sub) {
                ops.add(Operator.SUB);
            }
            if (this.mul) {
                ops.add(Operator.MUL);
            }
            if (this.div) {
                ops.add(Operator.DIV);
            }
            return ops;
        }
    }

    public static enum Operator {
        ADD,
        SUB,
        MUL,
        DIV;


        public String getPrefix() {
            return this.name().toLowerCase() + "_";
        }
    }

    public static class Operation {
        private final Column left;
        private final Column right;
        private final Column value;
        private final Operator operator;

        public Operation(Column left, Column right, Column value, Operator operator) {
            this.left = left;
            this.right = right;
            this.value = value;
            this.operator = operator;
        }

        public void compute(Row row) {
            double l = row.getAsDoubleOrNaN(this.left);
            double r = row.getAsDoubleOrNaN(this.right);
            double v = Double.NaN;
            if (Double.isNaN(l) || Double.isNaN(r)) {
                return;
            }
            switch (this.operator) {
                case ADD: {
                    v = l + r;
                    break;
                }
                case SUB: {
                    v = l - r;
                    break;
                }
                case MUL: {
                    v = l * r;
                    break;
                }
                case DIV: {
                    if (r == 0.0) {
                        return;
                    }
                    v = l / r;
                }
            }
            row.put(this.value, v);
        }
    }
}

