/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.reshaping.MultiColumnFoldMeta;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MultiColumnByPrefixFold
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<MultiColumnByPrefixFold, Parameter> META = new MultiColumnFoldMeta<MultiColumnByPrefixFold, Parameter>(){

        @Override
        public String getName() {
            return "MultiColumnByPrefixFold";
        }

        @Override
        public String getDocPage() {
            return "fold-columns-by-pattern";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.MultiColumnByPrefixFold.DESCRIPTION", 1.actionVerb("Fold") + " multiple columns by pattern"), false).withMNESParam("columnNamePattern", this.translate(language, "SHAKER.PROCESSOR.MultiColumnByPrefixFold.DESCRIPTION.COLUMN_NAME_PATTERN", "Columns to fold pattern")).withParam("columnNameColumn", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.MultiColumnByPrefixFold.DESCRIPTION.COLUMN_NAME_COLUMN", "Column for fold name")).withParam("columnContentColumn", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.MultiColumnByPrefixFold.DESCRIPTION.COLUMN_CONTENT_COLUMN", "Column for fold value")).withParam("foldRemoveFoldedColumns", "boolean", false, true, this.translate(language, "SHAKER.PROCESSOR.MultiColumnByPrefixFold.DESCRIPTION.FOLD_REMOVE_FOLDED_COLUMNS", "Remove folded columns"));
        }

        @Override
        public Object selfReport(Parameter p) {
            JsonObject out = new JsonObject();
            if (p.foldRemoveFoldedColumns != null) {
                out.addProperty("foldRemoveFoldedColumns", p.foldRemoveFoldedColumns);
            }
            return out;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.MultiColumnByPrefixFold.HELP", "Transforms values from multiple columns into one line per column. This processor selects the columns to fold using a pattern. It only creates lines for non-empty columns.\nIf the pattern has a capture group, this processor uses the captured portion of the column name instead of the full column name.\n# Examples\nUsing `.*_score` as a column to fold pattern:\n<table><tr><th>person</th><th>age</th><th>Q1_score</th><th>Q2_score</th><th>Q3_score</th></tr><tr><td>Bill</td><td>33</td><td>1</td><td>&nbsp;</td><td>4</td></tr>\nBecomes : \n<table><tr><th>person</th><th>age</th><th>quarter</th><th>score</th></tr><tr><td>Bill</td><td>33</td><td>Q3_score</td><td>4</td></tr>\nUsing a capture group, with the pattern `(.*)_score`, the example becomes:\n<table><tr><th>person</th><th>age</th><th>quarter</th><th>score</th></tr><tr><td>Bill</td><td>33</td><td>Q3</td><td>4</td></tr>\n# Options\n**Columns to fold pattern**\nWrite a regular expression to find matching columns, or choose **Find with Smart Pattern** to get help writing a regular expression. In the Smart Pattern window, you can highlight the portion of the column name that you wish to use. To use a pattern in the processor, select it and choose **OK**.\n**Column for fold name**\nGive a name for the new column that will contain the fold name. (\u201cQuarter\u201d in the example.)\n**Column for fold value**\nGive a name for the new column that will contain the fold value. (\u201cScore\u201d in the example.)\n**Remove folded columns**\nCheck the box to delete folded columns after running the recipe.\n# Related resources\nThis processor is a variant of Fold multiple columns. Read more about that processor in the [Dataiku documentation](https://doc.dataiku.com/dss/11.0/preparation/processors/fold-columns-by-name.html)");
        }

        @Override
        public MultiColumnByPrefixFold build(Parameter parameter) throws Exception {
            return new MultiColumnByPrefixFold(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter multiColumnPrefixFoldParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                Set<String> impactedColumns = multiColumnPrefixFoldParams.getImpactedColumns(previousDatasetPairLineage.getOutputColumns());
                DatasetPairLineage updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage, (Collection<String>)impactedColumns, multiColumnPrefixFoldParams.columnNameColumn, multiColumnPrefixFoldParams.columnContentColumn, multiColumnPrefixFoldParams.foldRemoveFoldedColumns);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final String columnNameColumn;
    private final String columnContentColumn;
    private final String columnNamePattern;
    private final Boolean foldRemoveFoldedColumns;
    private Pattern columnNameCompiledPattern;
    private Column foldValueCD;
    private Column foldNameCD;
    private List<String> removableColumns = new ArrayList<String>();

    public MultiColumnByPrefixFold(Parameter parameter) {
        this.columnNameColumn = parameter.columnNameColumn;
        this.columnContentColumn = parameter.columnContentColumn;
        this.columnNamePattern = parameter.columnNamePattern;
        this.foldRemoveFoldedColumns = parameter.foldRemoveFoldedColumns == null ? false : parameter.foldRemoveFoldedColumns;
    }

    public void init() throws Exception {
        try {
            this.columnNameCompiledPattern = Pattern.compile(this.columnNamePattern);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("The pattern is invalid: " + ExceptionUtils.getMessageWithCauses((Throwable)ex), ex);
        }
    }

    public void processRow(Row row) throws Exception {
        HashMap foldedColumns = Maps.newHashMap();
        ArrayList notFoldedColumns = Lists.newArrayList();
        String firstFoldedColumn = null;
        for (Column column : this.getCf().columns()) {
            if (row.get(column) == null) continue;
            Matcher matcher = this.columnNameCompiledPattern.matcher(column.getName());
            if (matcher.matches()) {
                if (firstFoldedColumn == null) {
                    firstFoldedColumn = column.getName();
                }
                if (matcher.groupCount() > 0) {
                    foldedColumns.put(column, matcher.group(1));
                    this.removableColumns.add(column.getName());
                    continue;
                }
                foldedColumns.put(column, column.getName());
                this.removableColumns.add(column.getName());
                continue;
            }
            notFoldedColumns.add(column);
        }
        if (foldedColumns.size() == 0) {
            this.getProcessorOutput().emitRow(row);
        } else {
            if (this.foldNameCD == null || this.foldValueCD == null) {
                this.foldNameCD = this.getCf().columnBefore(firstFoldedColumn, this.columnNameColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
                this.foldValueCD = this.getCf().columnBefore(firstFoldedColumn, this.columnContentColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            for (Map.Entry entry : foldedColumns.entrySet()) {
                Row emitted = this.getRf().row();
                for (Column notFoldedColumn : notFoldedColumns) {
                    emitted.put(notFoldedColumn, row.get(notFoldedColumn));
                }
                emitted.put(this.foldNameCD, (String)entry.getValue());
                emitted.put(this.foldValueCD, row.get((Column)entry.getKey()));
                this.getProcessorOutput().emitRow(emitted);
            }
        }
    }

    public void postProcess() throws Exception {
        if (this.foldRemoveFoldedColumns.booleanValue()) {
            for (String column : this.removableColumns) {
                this.getCf().deleteColumn(column);
            }
        }
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String columnNameColumn;
        public String columnContentColumn;
        public String columnNamePattern;
        Boolean foldRemoveFoldedColumns;

        public Set<String> getImpactedColumns(Set<String> availableColumns) {
            Pattern columnNameCompiledPattern;
            try {
                columnNameCompiledPattern = Pattern.compile(this.columnNamePattern);
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("The pattern is invalid: " + ExceptionUtils.getMessageWithCauses((Throwable)ex), ex);
            }
            HashSet<String> impactedColumns = new HashSet<String>();
            for (String c2 : availableColumns) {
                if (!columnNameCompiledPattern.matcher(c2).matches()) continue;
                impactedColumns.add(c2);
            }
            return impactedColumns;
        }

        public void validate() throws IllegalArgumentException {
        }
    }
}

