/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RepeatableUnfold
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<RepeatableUnfold, Parameter> META = new ProcessorMeta<RepeatableUnfold, Parameter>(){

        @Override
        public String getName() {
            return "RepeatableUnfold";
        }

        @Override
        public String getDocPage() {
            return "triggered-unfold";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.RepeatableUnfold.HELP", "This processor is used to reassemble several rows when a specific value is encountered. \n\nIt is useful for analysis of \"interaction sessions\" (a series of events with a specific event marking the beginning of a new interaction session). For example, while analyzing the logs of a web game, the \"start game\" event would be the beginning event.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.RepeatableUnfold.DESCRIPTION", "Triggered unfold")).withMNEColParam("keyColumn", this.translate(language, "SHAKER.PROCESSOR.RepeatableUnfold.DESCRIPTION.KEY_COLUMN", "Column acting as event key")).withMNEColParam("foldColumn", this.translate(language, "SHAKER.PROCESSOR.RepeatableUnfold.DESCRIPTION.FOLD_COLUMN", "Fold column")).withMNESParam("foldTrigger", this.translate(language, "SHAKER.PROCESSOR.RepeatableUnfold.DESCRIPTION.FOLD_TRIGGER", "Folding trigger value")).withMNEColParam("dataColumn", this.translate(language, "SHAKER.PROCESSOR.RepeatableUnfold.DESCRIPTION.DATA_COLUMN", "Column with data"));
        }

        @Override
        public RepeatableUnfold build(Parameter parameter) throws Exception {
            return new RepeatableUnfold(parameter);
        }
    };
    final Parameter parameter;
    Column keyCd;
    Column foldCd;
    Column dataCd;
    Map<String, Data> perKeyData = new HashMap<String, Data>();
    private static Logger logger = Logger.getLogger((String)"unfold2");

    public RepeatableUnfold(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.keyCd = this.getCf().column(this.parameter.keyColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.foldCd = this.getCf().column(this.parameter.foldColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.dataCd = this.getCf().column(this.parameter.dataColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.getCf().column(this.parameter.foldTrigger, Processor.ProcessorRole.OUTPUT_COLUMN);
        this.getCf().column("prev_" + this.parameter.foldTrigger, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String key = row.get(this.keyCd);
        if (key == null) {
            logger.info((Object)("Does not parse for " + this.keyCd.getName()));
            return;
        }
        String fold = row.get(this.foldCd);
        Data d = this.perKeyData.get(key);
        if (d == null) {
            d = new Data();
            this.perKeyData.put(key, d);
        }
        if (this.parameter.foldTrigger.equals(fold)) {
            if (d.curDataValues.size() > 0) {
                Row newRow = this.getRf().row();
                newRow.put(this.getCf().column(this.parameter.keyColumn, Processor.ProcessorRole.INPUT_COLUMN), key);
                if (d.prevTriggerValue != null) {
                    newRow.put(this.getCf().column("prev_" + this.parameter.foldTrigger, Processor.ProcessorRole.OUTPUT_COLUMN), d.prevTriggerValue);
                }
                for (int i = 0; i < d.curDataValues.size(); ++i) {
                    newRow.put(this.getCf().column(d.curFoldValues.get(i), Processor.ProcessorRole.OUTPUT_COLUMN), d.curDataValues.get(i));
                    if (d.curFoldValues.get(i) == null || !d.curFoldValues.get(i).equals(this.parameter.foldTrigger)) continue;
                    d.prevTriggerValue = d.curDataValues.get(i);
                }
                this.getProcessorOutput().emitRow(newRow);
            }
            d.curDataValues.clear();
            d.curFoldValues.clear();
        }
        d.curDataValues.add(row.get(this.dataCd));
        d.curFoldValues.add(fold);
    }

    public void postProcess() throws Exception {
        for (Map.Entry<String, Data> e : this.perKeyData.entrySet()) {
            Data d = e.getValue();
            if (e.getValue().curDataValues.size() <= 0) continue;
            Row newRow = this.getRf().row();
            newRow.put(this.getCf().column(this.parameter.keyColumn, Processor.ProcessorRole.INPUT_COLUMN), e.getKey());
            if (d.prevTriggerValue != null) {
                newRow.put(this.getCf().column("prev_" + this.parameter.foldTrigger, Processor.ProcessorRole.OUTPUT_COLUMN), d.prevTriggerValue);
            }
            for (int i = 0; i < d.curDataValues.size(); ++i) {
                newRow.put(this.getCf().column(d.curFoldValues.get(i), Processor.ProcessorRole.OUTPUT_COLUMN), d.curDataValues.get(i));
            }
            this.getProcessorOutput().emitRow(newRow);
        }
        this.getProcessorOutput().lastRowEmitted();
        this.getCf().deleteColumn(this.parameter.foldColumn);
        this.getCf().deleteColumn(this.parameter.dataColumn);
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String keyColumn;
        public String foldColumn;
        public String foldTrigger;
        public String dataColumn;

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class Data {
        String prevTriggerValue;
        List<String> curFoldValues = new ArrayList<String>();
        List<String> curDataValues = new ArrayList<String>();

        private Data() {
        }
    }
}

