/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.sparksql;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.sparksql.RemotedSparkSQLHandler;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkSubmitSparkSQLHandler
extends RemotedSparkSQLHandler {
    @Autowired
    private InsecureProcessesLaunchService insecureLaunchService;
    private final DKUtils.ExecOutputConsumer eoc;
    private final IsolableProcess p;
    private static Logger logger = Logger.getLogger((String)"dip.livy.remote.sparksubmit.sparksql");

    public SparkSubmitSparkSQLHandler(AuthCtx authCtx, ProcessBuilder builder, ResponderKernelLink serverSocket, SparkJobHelper.SparkJobContext context, String projectKey, UserImpersonationTarget impersonationTarget) throws Exception {
        super(serverSocket, context, projectKey);
        SpringUtils.getInstance().autowire((Object)this);
        File processRunDir = builder.directory();
        File logOutputFile = new File(processRunDir, "process-out.log");
        if (context.impersonatesRemotely()) {
            logger.info((Object)("Run command securely, as user " + System.getProperty("user.name")));
            this.p = new RegularProcess(builder, processRunDir);
            this.p.start();
        } else {
            logger.info((Object)("Run command insecurely, from user " + System.getProperty("user.name")));
            this.p = this.insecureLaunchService.launch(authCtx, projectKey, null, processRunDir, builder, impersonationTarget.unixUser);
        }
        OutputStreamWriter fwr = new OutputStreamWriter((OutputStream)new FileOutputStream(logOutputFile), StandardCharsets.UTF_8);
        this.eoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)fwr, true)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)fwr, true));
        this.eoc.start(this.p.getInputStream(), this.p.getErrorStream(), null);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SparkSubmitSparkSQLHandler.this.runAndWait();
                }
                catch (Throwable e) {
                    logger.error((Object)"Error in running spark-submit", e);
                }
            }
        });
        t.start();
    }

    private void runAndWait() throws Exception {
        int rv = this.p.waitFor();
        this.eoc.finish();
        if (rv == 0 && this.context != null) {
            rv = this.context.doubleCheckRunStarted();
        }
        if (rv != 0) {
            File errorFile = new File(this.context.getLocalRunDir(), "error.json");
            if (errorFile.isFile()) {
                logger.info((Object)("Error file found, trying to throw it: " + String.valueOf(errorFile)));
                SerializedError err = null;
                try {
                    err = (SerializedError)JSON.parseFile((File)errorFile, SerializedError.class);
                }
                catch (Throwable t) {
                    logger.error((Object)"Could not parse error file", t);
                }
                if (err != null) {
                    logger.info((Object)("Now err: " + JSON.log((Object)err)));
                    throw new APIError.SerializedErrorException(err);
                }
            }
            throw new ProcessDiedException("Job process seems to have died, return value " + rv, null);
        }
    }

    @Override
    protected void closeRemote() {
        try {
            logger.info((Object)"Killing spark driver");
            this.p.niceThenEvilKill();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to kill spark driver", (Throwable)e);
        }
    }
}

