/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.sqs;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.streaming.endpoints.StringBasedFormats;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatSerializer;

public class StringSQSFormat {

    public static class StringSQSFormatSerializer
    implements SQSFormatSerializer {
        private final StringSQSFormatParams params;
        private StringBasedFormats.SingleValueFormatSerializer serializer;

        public StringSQSFormatSerializer(StringSQSFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, Schema schema) {
            this.serializer = new StringBasedFormats.SingleValueFormatSerializer(cf, this.params.columnName);
        }

        @Override
        public String serialize(Row row) {
            return this.serializer.serialize(row);
        }
    }

    public static class StringSQSFormatDeserializer
    implements SQSFormatDeserializer {
        private final StringSQSFormatParams params;
        private RowFactory rf;
        private StringBasedFormats.SingleValueFormatDeserializer deserializer;

        public StringSQSFormatDeserializer(StringSQSFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, RowFactory rf, Schema schema) {
            this.rf = rf;
            this.deserializer = new StringBasedFormats.SingleValueFormatDeserializer(cf, this.params.columnName);
        }

        @Override
        public Row deserialize(String record) {
            Row row = this.rf.row();
            this.deserializer.deserialize(record, row);
            return row;
        }
    }

    public static class StringSQSFormatParams {
        public String columnName;
    }
}

