/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DeploymentMonitorThread;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.containers.exec.YamlUtils;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInfra;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractWebAppKubernetesKernel
implements WebAppBackendKernel,
DeploymentMonitorThread.RunningProcessList {
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    protected final WebApp webApp;
    protected final AuthCtx authCtx;
    protected final JsonObject userVariables;
    protected final WebAppLaunchInfo launchInfo;
    protected final ContainerExecRuntimeConfig containerConfig;
    protected final APITicketService.Ticket ticket;
    protected final File workingDir;
    protected final DKUtils.LineSubscriptionAttacher backendLog;
    protected final DKUtils.LineSubscriptionAttacher setupLog;
    protected final DKUtils.SmartLogTailBuilder smartLogTailBuilder;
    protected final WebAppSecurityInfo securityInfo;
    protected String executionId;
    protected ComputeResourceUsage cru;
    protected ArrayList<String> deploymentStartFiles;
    protected DeploymentMonitorThread deploymentMonitorThread;
    protected WebAppBackendInstance webAppBackendInstance;
    protected List<RegularProcess> running = Lists.newArrayList();
    static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.kubernetes");

    public AbstractWebAppKubernetesKernel(WebApp webApp, ContainerExecRuntimeConfig containerConfig, AuthCtx authCtx, JsonObject userVariables, WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, File workingDir, APITicketService.Ticket ticket, DKUtils.LineSubscriptionAttacher backendLog, DKUtils.LineSubscriptionAttacher setupLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        this.webApp = webApp;
        this.containerConfig = containerConfig;
        this.authCtx = authCtx;
        this.userVariables = userVariables;
        this.launchInfo = launchInfo;
        this.securityInfo = securityInfo;
        this.workingDir = workingDir;
        this.ticket = ticket;
        this.backendLog = backendLog;
        this.setupLog = setupLog;
        this.smartLogTailBuilder = smartLogTailBuilder;
        this.executionId = AbstractWebAppKubernetesKernel.createExecutionId(webApp.type, launchInfo.backendId);
        SpringUtils.getInstance().autowire((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRunning(RegularProcess toClose) {
        List<RegularProcess> list = this.running;
        synchronized (list) {
            this.running.add(toClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRunning(RegularProcess toClose) {
        List<RegularProcess> list = this.running;
        synchronized (list) {
            this.running.remove((Object)toClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RegularProcess> getRunning() {
        List<RegularProcess> list = this.running;
        synchronized (list) {
            return Lists.newArrayList(this.running);
        }
    }

    @Override
    public void killRunningProcesses() {
        for (RegularProcess p : this.getRunning()) {
            try {
                p.evilKill();
            }
            catch (IOException e) {
                logger.error((Object)("Could not stop process " + String.valueOf((Object)p)), (Throwable)e);
            }
        }
    }

    private static String createExecutionId(String webAppType, String backendId) {
        String suffix = "-" + backendId;
        return (KubernetesExecUtils.getNormalizedId(webAppType, 63 - suffix.length()) + suffix).toLowerCase();
    }

    public static Exposables.Exposable cleanupKernel(final AuthCtx authCtx, final WebApp webApp, ContainerExecRuntimeConfig containerConfig, WebAppLaunchInfo launchInfo, final File workingDir, DKUtils.RotatingAttachableLoggingSubscription setupLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder, final JsonObject exposableInfo) {
        final String executionId = AbstractWebAppKubernetesKernel.createExecutionId(webApp.type, launchInfo.backendId);
        try {
            ProcessBuilder cleanupDeploymentProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, webApp.projectKey, containerConfig, true, "delete", "deployment", "-l", "dataiku.com/dku-execution-id=" + executionId));
            cleanupDeploymentProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
            cleanupDeploymentProcessBuilder.directory(workingDir);
            setupLog.handle("Cleanup deployment " + Joiner.on((String)" ").join(cleanupDeploymentProcessBuilder.command()), false);
            RegularProcess cleanupDeploymentProcess = new RegularProcess(cleanupDeploymentProcessBuilder, workingDir);
            cleanupDeploymentProcess.start();
            DKUtils.ExecOutputConsumer cleanupDeploymentEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)setupLog).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)setupLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withTimestamps(true).withLineContext("[k8s] ");
            cleanupDeploymentEoc.start(cleanupDeploymentProcess.getInputStream(), cleanupDeploymentProcess.getErrorStream(), null);
            int rv = cleanupDeploymentProcess.waitFor();
            if (rv != 0) {
                throw new Exception("Unable to cleanup deployment " + rv);
            }
            cleanupDeploymentEoc.finish();
        }
        catch (Exception e) {
            logger.warn((Object)"Deployment cleanuping failed", (Throwable)e);
        }
        try {
            File[] yamlFiles = workingDir.listFiles((f, n) -> n.endsWith(".yaml"));
            if (yamlFiles != null && yamlFiles.length > 0) {
                ArrayList deploymentStartFiles = Lists.newArrayList();
                for (File f2 : yamlFiles) {
                    deploymentStartFiles.add("-f");
                    deploymentStartFiles.add(f2.getAbsolutePath());
                }
                KubernetesExecUtils.delete(authCtx, webApp.projectKey, containerConfig, true, deploymentStartFiles.toArray(new String[0]));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Interrupted while cleaning up Kubernetes deployment", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn((Object)"Deployment cleanup failed", (Throwable)e);
        }
        return new Exposables.KubernetesExposable(){

            @Override
            public int getContainerizedPort() {
                return exposableInfo.has("exposedPort") ? exposableInfo.get("exposedPort").getAsInt() : 10000;
            }

            @Override
            public String getExposedService() {
                return null;
            }

            @Override
            public File getTmpDir() {
                return workingDir;
            }

            @Override
            public String getNamePrefix() {
                return "dku-webapp";
            }

            @Override
            public Map<String, String> getLabels() {
                return new HashMap<String, String>();
            }

            @Override
            public String getExecutionId() {
                return executionId;
            }

            @Override
            public Map<String, String> getAnnotations() {
                HashMap<String, String> annotations = new HashMap<String, String>();
                annotations.put("dataiku.com/dku-execution-id", executionId);
                annotations.put("dataiku.com/dku-execution-type", ComputeResourceUsageContext.ComputeResourceUsageContextType.WEBAPP_BACKEND.name());
                annotations.put("dataiku.com/dku-exec-submitter", authCtx.getIdentifier());
                annotations.put("dataiku.com/dku-install-id", ApplicationConfigurator.getInstallId());
                annotations.put("dataiku.com/dku-project-key", webApp.projectKey);
                annotations.put("dataiku.com/dku-webapp-id", webApp.id);
                return annotations;
            }

            @Override
            public Map<String, String> getSelectors() {
                HashMap<String, String> selectors = new HashMap<String, String>();
                selectors.put("dataiku.com/dku-execution-id", executionId);
                return selectors;
            }

            @Override
            public String getPropertiesPrefix() {
                return "webapp";
            }

            @Override
            public List<SimpleKeyValue> getProperties() {
                return Lists.newArrayList();
            }
        };
    }

    @Override
    public WebAppBackendKernel.MainKernelProcess prepareRun(WebAppBackendInstance webAppBackendInstance, ExposedEndpointConsumer.ExposedEndpoint expectedExposedEndpoint) throws Exception {
        this.webAppBackendInstance = webAppBackendInstance;
        Object command = this.getCommand();
        String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(this.launchInfo.envName, this.getEnvLang(), this.webApp.projectKey);
        CodeEnvModel.EnvFullRef env = new CodeEnvModel.EnvFullRef(this.getEnvLang(), this.launchInfo.envName, envVersion);
        RemoteRunsRegistry.add(this.executionId, this.authCtx, this.webApp.projectKey, this.workingDir.getPath(), this.workingDir.getPath(), this.getExecutionType(), JSON.json((Object)command), "", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(env));
        String imageId = ContainerExecImagesHelper.getImageTagToUse(this.containerConfig.dockerHost, this.containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC, this.getEnvLang(), this.launchInfo.envName, envVersion);
        imageId = ContainerExecImagesHelper.withRepositoryURL(this.containerConfig, imageId);
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = this.workingDir.getAbsolutePath();
        EnvironmentStash envStash = this.getEnvironmentForRemoteKernel();
        if (this.userVariables != null) {
            envStash.customVariables = (Map)JSON.parse((JsonElement)this.userVariables, (TypeToken)new TypeToken<Map<String, Object>>(){});
        }
        if (this.launchInfo.pluginId != null) {
            envStash.env.put("DKU_PLUGIN_ID", this.launchInfo.pluginId);
            WebAppBackend.putResourceFolderEnvironmentVariable(envStash.env, "/home/dataiku/plugin/resource");
        }
        if (this.launchInfo.config != null) {
            envStash.env.put("DKU_CUSTOM_WEBAPP_CONFIG", JSON.json((Object)this.launchInfo.config));
        }
        if (this.launchInfo.pluginConfig != null) {
            envStash.env.put("DKU_PLUGIN_CONFIG", JSON.pretty((Object)this.launchInfo.pluginConfig));
        }
        envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
        envResource.jobId = this.executionId;
        RemoteRunsRegistry.get((String)this.executionId).envResource = envResource;
        logger.infoV("Executing recipe on Kubernetes with config=%s, using image '%s', executionId=%s", new Object[]{this.containerConfig.name, imageId, this.executionId});
        File secretFile = new File(this.workingDir, "secret_" + this.executionId + ".yaml");
        File deploymentFile = new File(this.workingDir, "deployment_" + this.executionId + ".yaml");
        File autoscalerFile = new File(this.workingDir, "hpa_" + this.executionId + ".yaml");
        File pdbFile = new File(this.workingDir, "pdb_" + this.executionId + ".yaml");
        this.deploymentStartFiles = Lists.newArrayList((Object[])new String[]{"-f", secretFile.getAbsolutePath(), "-f", deploymentFile.getAbsolutePath()});
        if (this.webApp.params.infra.scaling.hpa) {
            this.deploymentStartFiles.add("-f");
            this.deploymentStartFiles.add(autoscalerFile.getAbsolutePath());
        }
        if (this.webApp.params.infra.podDisruptionBudget.enable) {
            this.deploymentStartFiles.add("-f");
            this.deploymentStartFiles.add(pdbFile.getAbsolutePath());
        }
        String k8sClusterId = new ClusterSelector().getClusterForProject(this.webApp.projectKey, Cluster.ClusterArchitecture.KUBERNETES);
        K8SAPIDeploymentInfra.K8SContainerLimits k8sContainerLimits = this.containerConfig.kubernetesResources;
        this.cru = ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)this.executionId, (IK8SContainerLimits)k8sContainerLimits, (String)this.containerConfig.name).reportStartNoFail();
        String[] cmd = KubernetesExecUtils.getKubeCtlApplyCommand(this.authCtx, this.webApp.projectKey, this.containerConfig, this.deploymentStartFiles.toArray(new String[0]));
        ProcessBuilder startProcessBuilder = new ProcessBuilder(new String[0]);
        startProcessBuilder.directory(this.workingDir);
        startProcessBuilder.command(cmd);
        startProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
        KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.authCtx, this.executionId, this.containerConfig);
        String secretDesc = KubernetesExecUtils.getTicketSecretConf(this.executionId, this.ticket.getSecret());
        WebAppBackendInfra infra = this.webApp.params.infra;
        String deploymentDesc = KubernetesExecUtils.getDeploymentConfForWebapp(this.authCtx, this.executionId, this.webApp.projectKey, laa, startProcessBuilder.environment(), imageId, this.containerConfig, infra.scaling.initialReplicas, this.getReadinessProbe());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("deployment=\n" + deploymentDesc));
        }
        if (infra.deploymentModifier != null && StringUtils.isNotBlank((String)infra.deploymentModifier.runnableType)) {
            deploymentDesc = this.applyModification(deploymentDesc, infra.deploymentModifier);
        }
        DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
        DKUFileUtils.writeFileUTF8((File)deploymentFile, (String)deploymentDesc);
        if (this.webApp.params.infra.scaling.hpa) {
            YamlUtils yamlUtils = new YamlUtils();
            List<JsonElement> jsonElements = yamlUtils.yamlToJsonElements(deploymentDesc);
            JsonElement elem = jsonElements.get(0);
            String deploymentName = elem != null && elem.isJsonObject() ? Optional.ofNullable(elem.getAsJsonObject().get("metadata")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(meta -> meta.get("name")).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).orElse("") : "";
            String autoscalerDesc = KubernetesExecUtils.getAutoscalerConf(this.executionId, deploymentName, this.containerConfig, infra.scaling);
            DKUFileUtils.writeFileUTF8((File)autoscalerFile, (String)autoscalerDesc);
        }
        if (this.webApp.params.infra.podDisruptionBudget.enable) {
            String pdbDesc = KubernetesExecUtils.getPodDisruptionBudgetConf(this.executionId, infra.podDisruptionBudget);
            DKUFileUtils.writeFileUTF8((File)pdbFile, (String)pdbDesc);
        }
        DKUtils.ExecOutputConsumer startEoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)this.setupLog).withErrorConsumer((DKUtils.ExecSubscription)this.setupLog).withTimestamps(true).withLineContext("[k8s] ");
        return new WebAppBackendKernel.KubernetesMainKernelProcess(startProcessBuilder, startEoc, this.executionId, 10000, KubernetesExecUtils.getPodName(this.executionId), this.authCtx, this.webApp.projectKey, this.webApp.id);
    }

    protected String applyModification(String yaml, K8SAPIDeploymentInfra.K8SYamlModifier modifier) throws DKUSecurityException, Exception {
        JsonObject ctx = new JsonObject();
        ctx.addProperty("usage", "webapp");
        ctx.addProperty("metricsJsonPath", "/metrics-json");
        ctx.addProperty("metricsPrometheusPath", "/metrics-prometheus");
        ctx.addProperty("metricsPort", "9000");
        return KubernetesExecUtils.applyYamlModifier(this.authCtx, this.webApp.projectKey, this.containerConfig, yaml, modifier, this.workingDir, ctx);
    }

    protected abstract Object getCommand() throws Exception;

    protected abstract String getReadinessProbe();

    protected abstract CodeEnvModel.EnvLang getEnvLang();

    protected abstract RemoteRunsRegistry.ExecutionType getExecutionType();

    @Override
    public void run(WebAppBackendKernel.MainKernelProcess mainKernelProcess) throws Exception {
        logger.info((Object)"Running kubectl");
        this.logLine("Start kernel with " + Joiner.on((String)" ").join(mainKernelProcess.pb.command()));
        RegularProcess startProcess = new RegularProcess(mainKernelProcess.pb, this.workingDir);
        startProcess.start();
        mainKernelProcess.eoc.start(startProcess.getInputStream(), startProcess.getErrorStream(), null);
        int startReturnValue = startProcess.waitFor();
        mainKernelProcess.eoc.finish();
        logger.info((Object)("kubectl process returned " + startReturnValue));
        if (startReturnValue != 0) {
            throw new Exception("kubectl failed to start deployment : " + startReturnValue);
        }
        String deploymentName = ((WebAppBackendKernel.KubernetesMainKernelProcess)mainKernelProcess).getDeploymentName();
        this.deploymentMonitorThread = new DeploymentMonitorThread(this.authCtx, this.webApp.projectKey, deploymentName, this.containerConfig, this.executionId, this.webAppBackendInstance, this.webApp.params.infra.scaling.initialReplicas, this.workingDir, this.backendLog, this.setupLog, this.smartLogTailBuilder, this);
        this.deploymentMonitorThread.doRollout();
        if (new File(this.workingDir, "error.json").exists()) {
            logger.warn((Object)"Rollout stopped because an error.json was seen, not starting the deployment monitoring");
            return;
        }
        this.deploymentMonitorThread.start();
        this.deploymentMonitorThread.join();
        if (this.cru != null) {
            this.cru.reportCompleteNoFail();
        }
        logger.info((Object)"Monitor thread done");
    }

    public void logLine(String line) {
        logger.info((Object)line);
        String lineWithTimestampAndContext = "[" + dateFormat.format(Instant.now()) + "] [k8s] " + line;
        try {
            this.setupLog.handle(lineWithTimestampAndContext, false);
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to log to rotating file", (Throwable)e);
        }
        this.smartLogTailBuilder.appendLine(lineWithTimestampAndContext);
    }

    protected EnvironmentStash getEnvironmentForRemoteKernel() {
        EnvironmentStash envStash = new EnvironmentStash();
        envStash.fillDefaultForRemote();
        envStash.fillCommunicationVars();
        envStash.apiTicket = this.ticket.getSecret();
        envStash.projectKey = this.webApp.projectKey;
        if (StringUtils.isNotBlank((String)this.launchInfo.envName)) {
            envStash.env.put("DKU_CODE_ENV_NAME", this.launchInfo.envName);
        }
        return envStash;
    }

    @Override
    public Integer getPid() {
        return null;
    }

    @Override
    public SmartLogTail getLogTail() {
        logger.info((Object)"Getting webapp log tail");
        return this.smartLogTailBuilder.get();
    }

    @Override
    public Exception getWebAppProcessRunException() {
        return null;
    }

    @Override
    public void kill() {
        logger.warn((Object)"Will kill Kubernetes deployment");
        this.killRunningProcesses();
        try {
            if (this.deploymentStartFiles != null) {
                KubernetesExecUtils.delete(this.authCtx, this.webApp.projectKey, this.containerConfig, true, this.deploymentStartFiles.toArray(new String[0]));
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not stop Kubernetes deployment", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Interrupted while stopping Kubernetes deployment", (Throwable)e);
        }
        if (this.deploymentMonitorThread != null) {
            this.deploymentMonitorThread.kill();
        }
    }

    protected Map<String, String> getRetrievableFiles() {
        HashMap<String, String> retrievable = new HashMap<String, String>();
        retrievable.put("container-nginx/nginx.conf", "/home/dataiku/nginx.conf");
        retrievable.put("container-nginx/access.log", "/home/dataiku/nginx/access.log");
        return retrievable;
    }

    @Override
    public void gatherFilesForDiagnostic(File runDir) {
        File localFile;
        byte[] data;
        String labelsFilter = "dataiku.com/dku-execution-id=" + this.executionId;
        ArrayList<String> podIds = new ArrayList<String>();
        try {
            ProcessBuilder listPodsProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.webApp.projectKey, this.containerConfig, false, "get", "pods", "-o", "json", "-l", labelsFilter, "--request-timeout=30s"));
            listPodsProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
            listPodsProcessBuilder.directory(this.workingDir);
            byte[] podListOut = DKUtils.execAndGetOutput((ProcessBuilder)listPodsProcessBuilder);
            JsonObject podList = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(podListOut), JsonObject.class);
            JsonArray items = podList.get("items").getAsJsonArray();
            for (JsonElement item : items) {
                String podId = item.getAsJsonObject().get("metadata").getAsJsonObject().get("name").getAsString();
                podIds.add(podId);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to retrieve list of pods for " + this.executionId + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        for (String objectType : new String[]{"deployments", "pods", "services", "ingresses", "hpa"}) {
            try {
                ProcessBuilder infoProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.webApp.projectKey, this.containerConfig, false, "describe", objectType, "-l", labelsFilter, "--request-timeout=30s"));
                infoProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                infoProcessBuilder.directory(this.workingDir);
                data = DKUtils.execAndGetOutput((ProcessBuilder)infoProcessBuilder);
                localFile = new File(runDir, "deployment-info/" + objectType + ".txt");
                DKUFileUtils.mkdirsParent((File)localFile);
                FileUtils.writeByteArrayToFile((File)localFile, (byte[])data);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to retrieve list of " + objectType + " for " + this.executionId + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        Map<String, String> retrievable = this.getRetrievableFiles();
        for (String podId : podIds) {
            File podDir = new File(runDir, podId);
            try {
                ProcessBuilder psProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.webApp.projectKey, this.containerConfig, false, "exec", podId, "--request-timeout=30s", "--", "ps", "-ef"));
                psProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                psProcessBuilder.directory(this.workingDir);
                data = DKUtils.execAndGetOutput((ProcessBuilder)psProcessBuilder);
                localFile = new File(podDir, "pod-info/ps.txt");
                DKUFileUtils.mkdirsParent((File)localFile);
                FileUtils.writeByteArrayToFile((File)localFile, (byte[])data);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to list processes in pod : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            try {
                ProcessBuilder findProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.webApp.projectKey, this.containerConfig, false, "exec", podId, "--request-timeout=30s", "--", "find", "/home/dataiku", "-ls"));
                findProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                findProcessBuilder.directory(this.workingDir);
                File localFile2 = new File(podDir, "pod-info/home_dir_listing.txt");
                DKUFileUtils.mkdirsParent((File)localFile2);
                try (FileOutputStream os = new FileOutputStream(localFile2);){
                    DKUtils.execAndCaptureOutput((ProcessBuilder)findProcessBuilder, (OutputStream)os);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to list files in pod : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            try {
                for (Map.Entry<String, String> retrieved : retrievable.entrySet()) {
                    localFile = new File(podDir, retrieved.getKey());
                    DKUFileUtils.mkdirsParent((File)localFile);
                    try {
                        ProcessBuilder cpFileProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.webApp.projectKey, this.containerConfig, false, "cp", "--request-timeout=30s", String.format("%s:%s", podId, retrieved.getValue()), localFile.getAbsolutePath()));
                        cpFileProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                        cpFileProcessBuilder.directory(this.workingDir);
                        DKUtils.execAndLogThrows((ProcessBuilder)cpFileProcessBuilder);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to retrieve file from pod " + podId + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to retrieve data from pod " + podId + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
    }
}

