/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.codestudio.backend;

import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioLibsProvider;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppBackendRunner;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppMeta;
import com.dataiku.dip.webapps.codestudio.backend.CodeStudioWebAppKubernetesKernel;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;

public class CodeStudioWebAppBackendRunner
extends AbstractWebAppBackendRunner
implements CodeStudioLibsProvider {
    private final CodeStudioObject codeStudio;
    private final CodeStudioTemplate template;

    public CodeStudioWebAppBackendRunner(WebApp webApp, WebAppBackend backend, JsonObject userVariables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) throws Exception {
        super(webApp, backend, userVariables, user, webAppBackendInstance);
        CodeStudioWebAppMeta.CodeStudioWebAppParams params = webApp.getParamsAs(CodeStudioWebAppMeta.CodeStudioWebAppParams.class);
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
            this.codeStudio = ((CodeStudioObjectsService)SpringUtils.getBean(CodeStudioObjectsService.class)).getMandatory(webApp.projectKey, params.codeStudioId);
            this.template = ((CodeStudioTemplatesService)SpringUtils.getBean(CodeStudioTemplatesService.class)).getMandatoryUnsafe(this.codeStudio.templateId);
        }
    }

    @Override
    protected WebAppBackendKernel createKernel(WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, ContainerExecRuntimeConfig containerConfig, APITicketService.Ticket ticket, File workingDir, DKUtils.LineSubscriptionAttacher backendLog, DKUtils.LineSubscriptionAttacher setupLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        if (containerConfig == null) {
            throw new UnsupportedOperationException("Can't run Code Studio webapp locally");
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.DOCKER) {
            throw new UnsupportedOperationException("Can't run Code Studio webapp on docker");
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
            return new CodeStudioWebAppKubernetesKernel(this.webApp, containerConfig, this.backend, this.codeStudio, this.template, this.authCtx, this.userVariables, launchInfo, securityInfo, workingDir, ticket, backendLog, setupLog, smartLogTailBuilder);
        }
        return null;
    }

    @Override
    public String getLivelinessPath() {
        if (this.kernel == null) {
            return "/";
        }
        String readinessProbeUrl = ((CodeStudioWebAppKubernetesKernel)this.kernel).readinessProbeUrl;
        if (StringUtils.isBlank((String)readinessProbeUrl)) {
            return "/";
        }
        KubernetesExecUtils.HttpGetActionParts parts = KubernetesExecUtils.getProbeParts(readinessProbeUrl);
        return StringUtils.defaultIfBlank((String)parts.path, (String)"/");
    }

    @Override
    public void getCodeStudioBundle_NT(String zoneId, String commitId, HttpServletResponse resp) throws Exception {
        CodeStudioMeta.SyncZoneInstance syncedZone = ((CodeStudioWebAppKubernetesKernel)this.kernel).getZone(zoneId);
        CodeStudioSyncZones.SyncZone zone = CodeStudioSyncZones.lookup(syncedZone.zone);
        resp.setStatus(200);
        resp.setContentType("application/octet-stream");
        resp.setHeader("Content-Disposition", "attachment; filename=\"code_studio_bundle.zip\"");
        if (zone.isVersioned()) {
            this.getVersionedCodeStudioBundle_NT(zone, syncedZone.pathInZone, (OutputStream)resp.getOutputStream());
        } else {
            this.getResourcesCodeStudioBundle_NT(zone, syncedZone.pathInZone, (OutputStream)resp.getOutputStream());
        }
    }

    public void getVersionedCodeStudioBundle_NT(CodeStudioSyncZones.SyncZone zone, String pathInZone, OutputStream os) throws IOException, DKUSecurityException {
        pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""));
        RelFile bundleFolder = zone.rootRelFile(this.authCtx, this.codeStudio).appendChildPath(pathInZone);
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
            if (t.exists(bundleFolder)) {
                ((FolderEditorService)SpringUtils.getBean(FolderEditorService.class)).streamFolderContent(bundleFolder, "", zone.fileFilter(), os, t, Collections.emptyMap());
            } else {
                ZipOutputStream ignored = new ZipOutputStream(os);
                ignored.close();
            }
        }
    }

    public void getResourcesCodeStudioBundle_NT(CodeStudioSyncZones.SyncZone zone, String pathInZone, OutputStream os) throws IOException, DKUSecurityException {
        File bundleFolder = zone.rootFile(this.authCtx, this.codeStudio);
        if (StringUtils.isNotBlank((String)(pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""))))) {
            bundleFolder = DKUFileUtils.getWithin((File)bundleFolder, (String[])pathInZone.split("/"));
        }
        ZipUnzipDir.zipDirectoryToStream(bundleFolder, os);
    }
}

