/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Max
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return null;
        }
        for (Object arg : args) {
            if (arg != null && !"".equals(arg)) continue;
            return null;
        }
        if (args.length >= 2 && args[0] != null) {
            Object max;
            if (args[0] instanceof Number) {
                max = (Number)args[0];
                for (Object arg : args) {
                    if (arg instanceof Number) {
                        Number nArg = (Number)arg;
                        if (!(nArg.doubleValue() > ((Number)max).doubleValue())) continue;
                        max = nArg;
                        continue;
                    }
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expect all arguments to be of the same type (numbers)");
                }
                return max;
            }
            if (args[0] instanceof DateTime) {
                max = (DateTime)args[0];
                for (Object arg : args) {
                    if (arg instanceof DateTime) {
                        DateTime dArg = (DateTime)arg;
                        if (max.compareTo((ReadableInstant)dArg) >= 0) continue;
                        max = dArg;
                        continue;
                    }
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expect all arguments to be of the same type (date)");
                }
                return max;
            }
            if (args[0] instanceof String) {
                max = (String)args[0];
                for (Object arg : args) {
                    if (arg instanceof String) {
                        String sArg = (String)arg;
                        if (((String)max).compareTo(sArg) >= 0) continue;
                        max = sArg;
                        continue;
                    }
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expect all arguments to be of the same type (string)");
                }
                return max;
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects at least 2 arguments");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Max.DOCUMENTATION", "Returns the greater of N numbers or N strings or N dates.").withParams("a, b ...").withReturns("number, string or date").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("-1", "5", "3").returns("5")).withExample(Example.with("\"luke\"", "\"leia\"").returns("\"luke\""));
    }
}

