from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....coremodel.checklists.checklists import Checklists, _Checklists
    from ....coremodel.version_tag.version_tag import VersionTag, _VersionTag

'''
Translated from class com.dataiku.dip.server.services.TaggableObjectsService$TaggableObject
Via: com.dataiku.dip.llm.retrieval.RetrievableKnowledge
'''


class _TaggableObject(TypedDict):
    checklists: 'Checklists'
    creationTag: NotRequired[Optional['VersionTag']]
    customFields: Dict[str, Any]
    description: NotRequired[Optional[str]]
    shortDesc: NotRequired[Optional[str]]
    tags: List[str]
    versionTag: NotRequired[Optional['VersionTag']]


#    Translate from class com.dataiku.dip.server.services.TaggableObjectsService$TaggableObject
#    @deprecated Translation is incomplete: annotate it with PyModel to generate a union of all concrete subclasses
TaggableObject = _TaggableObject


# EOF
