(function() {
    "use strict";

    const addDatasetList = {
        bindings: {
            flowScope: '=?',
            datasetsMenus: '=',
            pinnedItems: '=',
            pinItem:'&',
            forcedColumnCount: '@',
            wrapperClass: '@',
            screenContainerId: '@',
            listMargin: '@',
            showConnectionCount: '@',
            isModal: '@'
        },
        templateUrl: 'static/dataiku/add-dataset-workflow/add-dataset-list/add-dataset-list.html',
        controller: function($scope, $element, $rootScope, $state, $stateParams, GlobalProjectActions, translate, AddDatasetWorkflowService, $window) {
            const ctrl = this;
            ctrl.translate = translate;
            ctrl.searchTerm = "";
            ctrl.connectionCount = 0;
            ctrl.sectionsCount = 0;

            /* Dataset sections */
            ctrl.datasetSections = [];

            function searchPredicate(item) {
                return item.label && item.label.toLowerCase().includes(ctrl.searchTerm.toLowerCase())
            }

            const deregister = $scope.$watch('$ctrl.datasetsMenus', function(newValue, oldValue) {
                if (newValue !== []) {
                    ctrl.fillDatasetsMenus();
                    deregister();
                }
            }, false);


            ctrl.fillDatasetsMenus = function() {
                ctrl.datasetSections = [];
                const filteredMenus = ctrl.datasetsMenus.filter(item => searchPredicate(item) && !item.items || item.items && item.items.some(searchPredicate));

                const sqlMenusItem = filteredMenus.find(item => item.id === "sql")
                if (sqlMenusItem) {
                    ctrl.datasetSections.push({
                        label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.SQL', 'SQL'),
                        items: sqlMenusItem.items?.filter(searchPredicate) ?? []
                    })
                }

                const filesTypes = ["Filesystem"]
                if (ctrl.isModal) {
                    filesTypes.push("UploadedFiles")
                }
                const filesMenus = filteredMenus.filter(item => filesTypes.includes(item.type))
                ctrl.datasetSections.push({
                    label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.FILES', 'Files'),
                    items: filesMenus
                })



                const nosqlMenusItem = filteredMenus.find(item => item.id === "nosql")
                if (nosqlMenusItem) {
                    ctrl.datasetSections.push({
                        label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.NOSQL', 'NoSQL'),
                        items: nosqlMenusItem.items?.filter(searchPredicate) ?? []
                    })
                }

                const hadoopMenus = filteredMenus.filter(item => item.type === "HDFS" || item.type === "hiveserver2" || item.type === "iceberg")
                ctrl.datasetSections.push({
                    label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.HADOOP', 'Hadoop'),
                    items: hadoopMenus
                })


                const networkMenusItem = filteredMenus.find(item => item.id === "network")
                if (networkMenusItem) {
                    ctrl.datasetSections.push({
                        label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.NETWORK', 'Network'),
                        items: networkMenusItem.items?.filter(searchPredicate) ?? []
                    })
                }

                const cloudStorageMenuItems = filteredMenus.find(item => item.id === "cloud")
                if (cloudStorageMenuItems) {
                    ctrl.datasetSections.push({
                        label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.CLOUD_STORAGE', 'Cloud Storage'),
                        items: cloudStorageMenuItems.items?.filter(searchPredicate) ?? []
                    })
                }


                const dataiKuManagedMenuItems = filteredMenus.find(item => item.id === "dataikuManaged")
                if (dataiKuManagedMenuItems) {
                    let dataikuItems = dataiKuManagedMenuItems.items
                    if (ctrl.isModal) {
                        dataikuItems = dataikuItems.filter(item => item.type !== "Sample")
                    }
                    ctrl.datasetSections.push({
                        label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.DATAIKU_MANAGED', "Dataiku Managed"),
                        items: dataikuItems?.filter(searchPredicate) ?? []
                    })
                }

                const otherMenus = filteredMenus.find(item => item.id === "other") ?? {
                    icon: 'icon-tasks',
                    id: 'other',
                    isSection: true,
                    label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.OTHER', "Other"),
                    items:[]
                }
                const alationMenu = filteredMenus.find(item => item.type === "import_from_alation")
                if(alationMenu) {
                    otherMenus.items.push(alationMenu)
                }
                if (otherMenus.items && otherMenus.items.length > 0) {
                    ctrl.datasetSections.push({
                        label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.OTHER', 'Other'),
                        items: otherMenus.items?.filter(searchPredicate) ?? []
                    })
                }

                const pluginsCategories = filteredMenus.filter(item => item.isPluginSection)
                pluginsCategories.forEach(category => {
                    ctrl.datasetSections.push({
                        label: category.label,
                        items: category.items,
                    })
                });

                const pluginsMenus = filteredMenus.filter(item => item.pluginId);
                ctrl.datasetSections.push({
                    label: translate('ADD_WORKFLOW.DROPDOWN.SECOND.PLUGINS', 'Plugins'),
                    items: pluginsMenus
                })



                ctrl.updateConnectionCount();
            }

            ctrl.updateConnectionCount = function() {
                ctrl.connectionCount = ctrl.datasetSections.reduce((count, section) => {
                    return count + section.items.length;
                }, 0)
                ctrl.sectionsCount = ctrl.datasetSections.filter(section => section.items.length).length;
            }

            ctrl.updateColumns = function() {
                /**
                 * Function that updates the CSS variables to specify:
                 * - the number of columns
                 * - the height of the list
                 * - the column filling strategy
                 * - weither it should scroll or not
                 *
                 * depending on the number of items and sections int he list
                 */

                const screenContainerId= ctrl.screenContainerId ?? "flow-widgets-container";
                const flowContainer = document.getElementById(screenContainerId); // the component that will be the max height available on the screen
                const wrapperContainerClass = ctrl.wrapperClass ?? 'add_dataset_workflow__dropdown';
                const element = document.getElementsByClassName(wrapperContainerClass)[0]; // the drowdown container (where the CSS variables are set). We use this element so that we can update the CSS variables event when the dropdown is not on screen.

                // Sizes of the list elements (update if any styling changes)
                const MAX_COLUMNS = 3;
                const ITEM_HEIGHT = 20;
                const ITEM_MARGIN = 8;
                const MIN_SECTION_SIZE = 40; // The size of a section with 0 items
                const SEARCH_BOX_HEIGHT = 38;
                const LIST_MARGIN = 16; // top + bottom
                const MENU_MARGIN = isNaN(Number(ctrl.listMargin)) ? 12 : Number(ctrl.listMargin); // How much margin we want top + bottom for the dropdown

                const containerHeight = flowContainer?.clientHeight ?? window.innerHeight; // how much screen real-estate we have
                const $menu = $(element);
                const globalMenuItemPos = $menu.offset();
                const globalMenuTop = globalMenuItemPos.top;
                const menuTop = globalMenuTop ? globalMenuTop : 0;

                const menuHeight = Math.floor(containerHeight - menuTop - SEARCH_BOX_HEIGHT - MENU_MARGIN); // how much space we can use for the dropdown

                const totalHeight = ctrl.connectionCount * ITEM_HEIGHT + (ctrl.connectionCount + 1) * ITEM_MARGIN + ctrl.sectionsCount * MIN_SECTION_SIZE + LIST_MARGIN; // the height the list would take as a single column

                const neededColumns = Math.ceil(totalHeight / menuHeight);
                const columnsCount = isNaN(Number(ctrl.forcedColumnCount)) ? Math.max(1, Math.min(neededColumns, MAX_COLUMNS)) : Number(ctrl.forcedColumnCount)

                const forcedHeight = columnsCount > 1 ? menuHeight : totalHeight;


                let internalHeight = 'auto';
                let columnFill = 'balanced';
                let menuHeightValue = neededColumns > MAX_COLUMNS ? forcedHeight + 'px' : 'auto';

                if (ctrl.searchTerm.length > 0) {
                    // When searching, we only want to change the column fill from 'balanced' to 'auto'
                    columnFill = 'auto';
                    const multi = element.getElementsByClassName('multi_column')
                    const currentHeight = multi.item(0).clientHeight;
                    internalHeight = currentHeight + 'px';
                } else {
                    element.style.setProperty('--column-count', `${columnsCount}`);
                    element.style.setProperty('--menu-height', menuHeightValue);
                }

                element.style.setProperty('--column-fill', `${columnFill}`);
                element.style.setProperty('--internal-list-height', `${internalHeight}`);

                if (!ctrl.isModal) {
                    // we only want to set a max height when using the menu and not the modal.
                    element.style.setProperty('--list-max-height', `${menuHeight}px`);
                }

            }

            ctrl.search = function() {
                ctrl.fillDatasetsMenus();
                ctrl.updateColumns();
            }

            ctrl.showCERestrictionModal = function(label) {
                if (!ctrl.flowScope || typeof ctrl.flowScope.showCERestrictionModal !== 'function') {
                    return;
                }
                ctrl.flowScope.showCERestrictionModal(label);
            }

            ctrl.displayPluginInfo = function(pluginId, showDatasets, showRecipes) {
                if (!ctrl.flowScope || typeof ctrl.flowScope.displayPluginInfo !== 'function') {
                    return;
                }
                ctrl.flowScope.displayPluginInfo(pluginId, showDatasets, showRecipes);
            }

            ctrl.getRelevantZoneId = function() {
                if (!ctrl.flowScope || typeof ctrl.flowScope.getRelevantZoneId !== 'function') {
                    return;
                }
                ctrl.relevantZoneId = ctrl.flowScope.getRelevantZoneId($stateParams.zoneId);
                return ctrl.relevantZoneId;
            }

            ctrl.$onInit = function() {
                ctrl.fillDatasetsMenus();
                ctrl.updateColumns();
                angular.element($window).on('resize', ctrl.updateColumns);
            }

            ctrl.$postLink = function() {
                const searchInput = $element[0].getElementsByClassName('basic-search-box__input').item(0)
                if (searchInput) {
                    searchInput.focus();
                }
            }

            ctrl.$onDestroy = function() {
                angular.element($window).off('resize', ctrl.updateColumns);
            }

            ctrl.togglePin = function(event, item) {
                event.stopPropagation();
                AddDatasetWorkflowService.togglePinItem(item.type, ctrl.flowScope);
            }

            ctrl.isPinned = function(item) {
                return ctrl.pinnedItems.find(pinnedItem => item.type === pinnedItem.type)
            }
        }
    }


    angular.module("dataiku.addDatasetWorkflow").component("addDatasetList", addDatasetList);
})();