(function() {
'use strict';
const app = angular.module('dataiku.agentdependencies', ['dataiku.services', 'dataiku.filters']);

app.directive('dependencyComponent', function() {
    return {
        restrict: 'E',
        scope: {
            currentDependencies: '=',
            addDependency: '&',
            description: '@',
            removeDependency: '&',
            warningMsg: '<'
        },
        controllerAs: '$ctrl',
        bindToController: true,
        templateUrl: 'templates/agent-tools/dependencies-component.html',
        controller: function($scope, StateUtils, CreateModalFromTemplate, FLOW_COMPUTABLE_DEPENDENCIES, $stateParams) {
            const $ctrl = this;

            $ctrl.computeDependencyLink = function(dependency) {
                // must cover all cases for FLOW_COMPUTABLE_DEPENDENCIES
                switch (dependency.type) {
                    case 'DATASET': return StateUtils.href.dataset(dependency.smartId, $stateParams.projectKey);
                    case 'SAVED_MODEL': return StateUtils.href.savedModel(dependency.smartId, $stateParams.projectKey);
                    case 'RETRIEVABLE_KNOWLEDGE': return StateUtils.href.retrievableKnowledge(dependency.smartId, $stateParams.projectKey, {tab: 'settings'}, { '#': 'core-settings' });
                }
            };

            $ctrl.isForeignObject = function(dependency) {
                return dependency.projectKey !== $stateParams.projectKey;
            };

            $ctrl.openModalForm = function() {
                CreateModalFromTemplate("/templates/agent-tools/add-editor-dss-dependency-modal.html", $scope, null, function(modalScope) {
                    modalScope.acceptedTypes = FLOW_COMPUTABLE_DEPENDENCIES
                    modalScope.confirm = (selectedDependency) => modalScope.resolveModal(selectedDependency);
                    modalScope.cancel = () => modalScope.dismiss();
                }).then((selectedDependency) => {
                    $ctrl.addDependency({ dependencyToAdd: selectedDependency });
                })
            };
        }
    };
});

app.controller('AddDependenciesDSSObjectModalController', function($scope, $stateParams) {
    $scope.newReference = {
        projectKey: $stateParams.projectKey
    };

    $scope.uiState = {
        selectedObject: {},
    };
});
})();
