(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards.insights');

    app.component('textTile', {
        templateUrl: '/templates/dashboards/insights/text/text_tile.html',
        bindings: {
            tileParams: '<',
            hook: '=',
            tile: '<'
        },
        controller: function($scope, TileLoadingState) {
            const ctrl = this;
            ctrl.text;

            ctrl.$onInit = function() {
                ctrl.load = function(resolve) {
                    ctrl.hook.loadStates[ctrl.tile.$tileId] = TileLoadingState.COMPLETE;
                    resolve();
                };

                if (ctrl.hook) {
                    ctrl.hook.loadPromises[ctrl.tile.$tileId] = ctrl.load;
                    ctrl.hook.reloadPromises[ctrl.tile.$tileId] = ctrl.load;
                    ctrl.hook.loadStates[ctrl.tile.$tileId] = TileLoadingState.WAITING;
                }
            };

            ctrl.$onChanges = function() {
                ctrl.text = ctrl.tileParams.displayedText;
            };

            $scope.$watch(
                function() {
                    return ctrl.tileParams && ctrl.tileParams.displayedText;
                },
                function(newVal, oldVal) {
                    if (newVal !== oldVal) {
                        ctrl.text = newVal;
                    }
                }
            );
        }
    });

    app.directive('textTileParams', function(CodeMirrorSettingService, Debounce, DashboardUtils, DashboardVariablesService) {
        return {
            templateUrl: '/templates/dashboards/insights/text/text_tile_params.html',
            scope: {
                tileParams: '=',
                setHorizontalAlignment: '&',
                setVerticalAlignment: '&',
                variables: '<'
            },
            link: function($scope, element) {
                $scope.editorOptions = CodeMirrorSettingService.get('text/plain');
                $scope.warningMessage = DashboardVariablesService.getWarningMessage($scope.tileParams.text, $scope.tileParams.displayedText);

                $scope.changeText = Debounce().withDelay(500, 500).wrap(updateDisplayedText);

                $scope.$watch('tileParams', function(newValue, oldValue) {
                    if (newValue !== oldValue) {
                        $scope.warningMessage = DashboardVariablesService.getWarningMessage($scope.tileParams.text, $scope.tileParams.displayedText);
                    }
                });

                function updateDisplayedText() {
                    DashboardUtils.expandVariables($scope.tileParams.text).then(data => {
                        $scope.tileParams.displayedText = data.data;
                        $scope.warningMessage = DashboardVariablesService.getWarningMessage($scope.tileParams.text, $scope.tileParams.displayedText);
                    });
                }

                $scope.codeMirror = element.find('.CodeMirror')[0].CodeMirror;

                $scope.addVarToTitle = function(event) {
                    const varEndPosition = $scope.codeMirror.getCursor();
                    const varStartPosition = { ...varEndPosition };
                    varStartPosition.ch = varStartPosition.ch - event.currentSearch.length;
                    $scope.codeMirror.replaceRange(event.variableName, varStartPosition, varEndPosition);

                    updateDisplayedText();
                };

                // avoid going back to the start of the line when navigating in the suggestions - doesn't work when moved to suggestions component
                $scope.codeMirror.on('keydown', function(_cm, event) {
                    const supportedKeys = ['ArrowDown', 'ArrowUp', 'Enter', 'Escape'];
                    if (supportedKeys.includes(event.key) && document.getElementsByClassName('variable-menu__list').length > 0) {
                        event.preventDefault();
                    }
                });
            }
        };
    });
})();
