(function() {
    angular.module('dataiku.charts').component('invalidChartPlaceholder', {
        templateUrl: '/static/dataiku/js/simple_report/components/invalid-chart-placeholder/invalid-chart-placeholder.component.html',
        bindings: {
            validity: '<',
            chartType: '<',
            chartVariant: '<',
            isInDashboard: '<',
            isInPredicted: '<',
            canEdit: '<',
            computeChartPreview: '<',
            computeChartOptionsPreview: '<',
            revertToLinoEngineAndReload: '<',
            forceExecute: '<',
            rebuildSampling: '<'
        },
        controller: function() {
            const ctrl = this;
            ctrl.canErrorBeDisplayedBothInChartsAndDashboards = false;

            ctrl.$onChanges = function() {
                if (!_.isNil(ctrl.validity)) {
                    ctrl.canErrorBeDisplayedBothInChartsAndDashboards = ctrl.validity.type === 'PIVOT_TABLE_TOO_MUCH_DATA' || ctrl.validity.type === 'CORRUPTED_LINO_CACHE' || ctrl.validity.type === 'EMPTY_CUSTOM_BINS';
                }
            };

        }
    });
})();
