(function () {
    "use strict";
    angular.module("dataiku.opals").factory("RecipeContextService", RecipeContextService);

    function RecipeContextService($rootScope, $timeout) {
        let currentRecipeData = null;

        function setCurrentRecipe(data) {
            currentRecipeData = data;
            $rootScope.$emit("dataiku.opals.RecipeContextService.setCurrentRecipe");
        }

        function context(stateInfo) {
            return new Promise((resolve, reject) => {
                if (stateInfo.toState.name === "projects.project.recipes.recipe") {
                    function callResolve() {
                        resolve({ ...stateInfo, ...{ context: [...stateInfo.context, currentRecipeData.recipe.type] } });
                    }

                    function currentRecipeDataMatchesStateInfo() {
                        return (
                            currentRecipeData.recipe.projectKey === stateInfo.toParams.projectKey &&
                            currentRecipeData.recipe.name === stateInfo.toParams.recipeName
                        );
                    }

                    if (currentRecipeData && currentRecipeDataMatchesStateInfo()) {
                        callResolve();
                        return;
                    }

                    const timeoutPromise = $timeout(() => {
                        reject("RecipeContextService: setCurrentRecipe() not called after 60 seconds");
                        deregister();
                    }, 60000);
                    const deregister = $rootScope.$on("dataiku.opals.RecipeContextService.setCurrentRecipe", () => {
                        if (currentRecipeDataMatchesStateInfo()) {
                            $timeout.cancel(timeoutPromise);
                            callResolve();
                        } else {
                            reject("RecipeContextService: Project key or Recipe name not matching");
                        }
                        deregister();
                    });
                } else {
                    reject(`RecipeContextService: Nominal route (${stateInfo.toState.name}) not matched`);
                }
            });
        }

        return {
            setCurrentRecipe,
            context,
        };
    }
})();
