(function(){
    "use strict";

    // Call with searchNotebookEditCellNameModalDirective
    const searchNotebookEditCellNameModal = {
        bindings : {
            cell: "<",
            modalControl: "<",
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-edit-cell-name-modal/search-notebook-edit-cell-name-modal.component.html",
        controller: function() {
            const $ctrl = this;

            $ctrl.$onInit = () => {
                $ctrl.cellName = $ctrl.cell.name;
            };

            $ctrl.saveName = function () {
                $ctrl.cell.name = $ctrl.cellName;
                $ctrl.modalControl.resolve();
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookEditCellNameModal", searchNotebookEditCellNameModal);
})();