(function() {
"use strict";

/**
 * <at-survey
 *      app-config="appConfig"
 *      ng-if="appConfig">
 * </at-survey>
 *
 *
 * @param { Object } appConfig
 *
 */
const atSurvey = {
    templateUrl: "/static/dataiku/surveys/at-survey/at-survey.component.html",
    bindings: {
        appConfig: "<"
    },
    controller: function atSurveyController($scope, $timeout, ATSurveyService, WT1, $filter) {
        const ctrl = this;

        ctrl.scores = Array.from({length: 5}, (_, i) => (i+1));
        const surveyInitState = {
            surveyScore: 0,
            showSurvey: false,
            loaded: false,
            finished: false,
            response: "",
            title: "",
            action: null,
        };

        ctrl.initSurveyState = function() {
            for (const property in surveyInitState) {
                ctrl[property] = surveyInitState[property];
            }
        };

        ctrl.selectScore = function(score) {
            ctrl.surveyScore = score;
        }

        // Survey ctrl initialization
        ctrl.initSurveyState();

        // We listen for dedicated event broadcast by the root scope to its children
        $scope.$on('atSurveyTriggeredEvent', function(e, actionTrigger) {
            ctrl.event = actionTrigger.event;
            ctrl.triggerSurvey(actionTrigger);
        })

        ctrl.triggerSurvey = function(actionTrigger) {
            ctrl.title = actionTrigger.title ? actionTrigger.title : "";
            ctrl.showSurvey = true;
            $timeout(function() {
                ctrl.loaded = true;
            });
        };

        ctrl.scoreInt = (score) => parseInt(score);

        ctrl.finish = function(action) {
            // if user clicks on something after submitting
            if (ctrl.finished) {
                return;
            }
            ctrl.finished = true;
            ctrl.action = action;
            if (action !== "SUBMIT") {
                // Hide the pop-up as soon as possible, unless the user has submitted the form
                ctrl.showSurvey = false;
            }

            ATSurveyService.updateATSurveySettings(ctrl.event, action)
                .success(() => {
                    const surveyContent = {
                        score: ctrl.surveyScore,
                        atSurveyType: ctrl.event,
                        response: $filter("escapeHtml")(ctrl.response || ""),
                    };

                    // We reset counter
                    ATSurveyService.resetCounter(ctrl.event);

                    if (action === "SUBMIT") {
                        WT1.event("action-triggered-survey", surveyContent);

                        // For animation
                        $timeout(function() {
                            ctrl.loaded = false;
                            $timeout(function() {
                                ctrl.showSurvey = false;
                            }, 1000);
                        }, 1000);
                    } else {
                        // If the user doesn't explicitly submit, we don't share info
                        WT1.event("action-triggered-survey-decline");

                        // We reinitialize the survey in case it pops twice during a session
                        ctrl.initSurveyState();

                        // We reset all counters if user has opted-out
                        if (action === "OPTOUT") {
                            ATSurveyService.deleteAllCounters();
                        }
                    }
                })
                .error(setErrorInScope.bind($scope));
        };
    },
};

angular.module("dataiku.surveys").component("atSurvey", atSurvey);
})();
