import logging

from dataiku.external_ml.proxy_model.common.inputformat import BaseWriter

logger = logging.getLogger(__name__)


class AzureMLJSONWriter(BaseWriter):
    NAME = "INPUT_AZUREML_JSON_WRITER_BASE"

    def __init__(self, client):
        super(AzureMLJSONWriter, self).__init__(client)

    def can_write(self, input_df):
        from azure.core.exceptions import HttpResponseError
        try:
            return self.write(input_df)
        except HttpResponseError as e:
            if 'value is not provided' in e.message:
                return False
            else:
                raise e

    def write(self, input_df):
        payload = self.build_request_payload(input_df)
        return self.client.call_endpoint(payload, {"Content-Type": 'application/json'})
