from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..promptstudio.prompt_studio.llm_structured_ref import LLMStructuredRef, _LLMStructuredRef
    from .field_range import FieldRange, _FieldRange
from ..llm_structured_ref.llm_structured_ref import LLMStructuredRef, _LLMStructuredRef

'''
Translated from class com.dataiku.dip.llm.EnrichedLLMStructuredRef
Via: PyModel annotation in the class hierarchy
'''


class _EnrichedLLMStructuredRef(_LLMStructuredRef, TypedDict):
    baseModelId: str
    canBeFinetuned: bool
    canDoNativeEmotionAnalysis: bool
    canDoNativeSentimentAnalysis: bool
    canGenerateCrossLanguageOutput: bool
    connectionDescription: str
    customClassificationRequiresHypothesisTemplate: bool
    embeddingSize: int
    friendlyName: str
    friendlyNameShort: str
    handlesSystemMessage: bool
    isReasoning: bool
    maxTokensLimit: int
    originalLLMIsUnreferenced: bool
    promptDriven: bool
    supportsImageInputs: bool
    temperatureRange: 'FieldRange'
    topKRange: 'FieldRange'


# List of all concrete subclasses of com.dataiku.dip.llm.EnrichedLLMStructuredRef
EnrichedLLMStructuredRef = Union[
    '_EnrichedLLMStructuredRef',
    'LLMStructuredRef',
]


# EOF
