from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...connections.sage_maker_generic_llm_connection.custom_sage_maker_model_type import CustomSageMakerModelType
    from ..enriched_llm_structured_ref.enriched_llm_structured_ref import EnrichedLLMStructuredRef, _EnrichedLLMStructuredRef
    from ..promptstudio.prompt_studio.llm_structured_ref import LLMStructuredRef, _LLMStructuredRef
    from .llm_type import LLMType

'''
Translated from class com.dataiku.dip.llm.LLMStructuredRef
Via: PyModel annotation in the class hierarchy
'''


class _LLMStructuredRef(TypedDict):
    connection: str
    deployment: str
    id: str
    model: str
    retrievableKnowledgeSmartId: str
    sageMakerModelType: 'CustomSageMakerModelType'
    savedModelSmartId: str
    savedModelVersionId: str
    type: 'LLMType'


# List of all concrete subclasses of com.dataiku.dip.llm.LLMStructuredRef
LLMStructuredRef = Union[
    'EnrichedLLMStructuredRef',
    '_LLMStructuredRef',
    '_LLMStructuredRef',
]


# EOF
