import logging

from .. import NextBlock, BlockHandler

logger = logging.getLogger("dku.agents.blocks_graph")

class SetStateEntriesBlockHandler(BlockHandler):
    def __init__(self, turn, sequence_context, block_config):
        super().__init__(turn, sequence_context, block_config)

    def process_stream(self, trace):
        logger.info("Set state entries block starting with config %s" % self.block_config)

        for entry in self.block_config.get("entriesToSet", []):
            key = entry.get("key")
            value = entry.get("value")
            logger.info("Setting state key %s to value %s" % (key, value))

            cel_engine = self.standard_cel_engine()
            eval_result = cel_engine.evaluate(value)

            self.turn.state_set(key, eval_result)

        yield NextBlock(id=self.block_config.get("nextBlock"))
