import dataiku

client = dataiku.api_client()
project = client.get_project(dataiku.default_project_key())
managed_folder = project.get_managed_folder('A_MANAGED_FOLDER_ID')

# Setup mlflow integration, storing artefacts in managed folder. Managed folder must already exist.
with project.setup_mlflow('A_MANAGED_FOLDER_ID') as mlflow:
    with mlflow.start_run(run_name="my_run"):
        # ...your MLflow code...
        mlflow.log_param("a", 1)
        mlflow.log_metric("b", 2)
