CREATE FUNCTION govern_drop_constraints(input_table_name text, input_column_names text[], input_constraint_type text)
   RETURNS void 
   LANGUAGE plpgsql
  AS
$$
BEGIN
	EXECUTE (
		WITH search_constraints AS (
			SELECT 
				constraint_catalog, 
				constraint_schema, 
				constraint_name, 
				table_name,
				array_agg(k.column_name ORDER BY k.ordinal_position) AS constraint_columns
			FROM information_schema.key_column_usage k
			JOIN information_schema.table_constraints t USING (
				constraint_catalog, constraint_schema, constraint_name, table_name
			)
			WHERE k.table_name = input_table_name
			AND k.table_schema = (SELECT CURRENT_SCHEMA)
			AND t.constraint_type = input_constraint_type
			GROUP BY constraint_catalog, constraint_schema, constraint_name, table_name
		)
		SELECT 'ALTER TABLE '|| table_name ||' DROP CONSTRAINT '|| constraint_name ||';'
		FROM search_constraints 
		WHERE constraint_columns::text[] = input_column_names
	);
END;
$$;

SELECT govern_drop_constraints('blueprint_role_assignments', ARRAY['blueprint_role_assignments_blueprint_id'], 'FOREIGN KEY');
ALTER TABLE blueprint_role_assignments ADD CONSTRAINT blueprint_role_assignments_blueprint_role_assignments_blu_fkey FOREIGN KEY (blueprint_role_assignments_blueprint_id) REFERENCES blueprints(blueprint_id);

SELECT govern_drop_constraints('blueprint_version_traces', ARRAY['blueprint_version_trace_blueprint_id','blueprint_version_trace_origin_version_id'], 'FOREIGN KEY');
ALTER TABLE blueprint_version_traces ADD CONSTRAINT blueprint_version_traces_blueprint_version_trac_blueprin_fkey1 FOREIGN KEY (blueprint_version_trace_blueprint_id, blueprint_version_trace_origin_version_id) REFERENCES blueprint_versions(blueprint_version_blueprint_id, blueprint_version_version_id);

SELECT govern_drop_constraints('blueprint_version_traces', ARRAY['blueprint_version_trace_blueprint_id','blueprint_version_trace_version_id'], 'FOREIGN KEY');
ALTER TABLE blueprint_version_traces ADD CONSTRAINT blueprint_version_traces_blueprint_version_trac_blueprint_fkey FOREIGN KEY (blueprint_version_trace_blueprint_id, blueprint_version_trace_version_id) REFERENCES blueprint_versions(blueprint_version_blueprint_id, blueprint_version_version_id);

SELECT govern_drop_constraints('global_api_key_mappings', ARRAY['global_api_key_mapping_artifact_id'], 'FOREIGN KEY');
ALTER TABLE global_api_key_mappings ADD CONSTRAINT global_api_key_mappings_global_api_key_mapping_artifact_i_fkey FOREIGN KEY (global_api_key_mapping_artifact_id) REFERENCES artifacts(artifact_id);

SELECT govern_drop_constraints('reference_relationships', ARRAY['reference_relationship_artifact_id_to'], 'FOREIGN KEY');
ALTER TABLE reference_relationships ADD CONSTRAINT reference_relationships_reference_relationship_artifact__fkey1 FOREIGN KEY (reference_relationship_artifact_id_to) REFERENCES artifacts(artifact_id);

SELECT govern_drop_constraints('reference_relationships', ARRAY['reference_relationship_artifact_id_from'], 'FOREIGN KEY');
ALTER TABLE reference_relationships ADD CONSTRAINT reference_relationships_reference_relationship_artifact_i_fkey FOREIGN KEY (reference_relationship_artifact_id_from) REFERENCES artifacts(artifact_id);

SELECT govern_drop_constraints('signoff_configurations', ARRAY['signoff_configuration_blueprint_id','signoff_configuration_version_id'], 'FOREIGN KEY');
ALTER TABLE signoff_configurations ADD CONSTRAINT signoff_configurations_signoff_configuration_blueprint_id_fkey FOREIGN KEY (signoff_configuration_blueprint_id, signoff_configuration_version_id) REFERENCES blueprint_versions(blueprint_version_blueprint_id, blueprint_version_version_id);

SELECT govern_drop_constraints('time_series_relationships', ARRAY['time_series_relationship_artifact_id'], 'FOREIGN KEY');
ALTER TABLE time_series_relationships ADD CONSTRAINT time_series_relationships_time_series_relationship_artifa_fkey FOREIGN KEY (time_series_relationship_artifact_id) REFERENCES artifacts(artifact_id);

SELECT govern_drop_constraints('uploaded_file_relationships', ARRAY['uploaded_file_relationship_artifact_id'], 'FOREIGN KEY');
ALTER TABLE uploaded_file_relationships ADD CONSTRAINT uploaded_file_relationships_uploaded_file_relationship_ar_fkey FOREIGN KEY (uploaded_file_relationship_artifact_id) REFERENCES artifacts(artifact_id);

SELECT govern_drop_constraints('uploaded_file_relationships', ARRAY['uploaded_file_relationship_uploaded_file_id'], 'FOREIGN KEY');
ALTER TABLE uploaded_file_relationships ADD CONSTRAINT uploaded_file_relationships_uploaded_file_relationship_up_fkey FOREIGN KEY (uploaded_file_relationship_uploaded_file_id) REFERENCES uploaded_files(uploaded_file_id);


DROP FUNCTION govern_drop_constraints;

