from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..beta.beta import Beta, _Beta
    from ..binomial.binomial import Binomial, _Binomial
    from ..exponential.exponential import Exponential, _Exponential
    from ..laplace.laplace import Laplace, _Laplace
    from ..log_normal.log_normal import LogNormal, _LogNormal
    from ..normal.normal import Normal, _Normal
    from ..normal_mixture.normal_mixture import NormalMixture, _NormalMixture
    from ..pareto.pareto import Pareto, _Pareto
    from ..poisson.poisson import Poisson, _Poisson
    from ..triangular.triangular import Triangular, _Triangular
    from ..weibull.weibull import Weibull, _Weibull
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.distributions.Distribution
Via: com.dataiku.dip.eda.compute.computations.univariate.FitDistribution
'''


class _Distribution(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.distributions.Distribution
Distribution = Union[
    'Beta',
    'Binomial',
    'Exponential',
    'Laplace',
    'LogNormal',
    'Normal',
    'NormalMixture',
    'Pareto',
    'Poisson',
    'Triangular',
    'Weibull',
]

# Types of class com.dataiku.dip.eda.compute.distributions.Distribution in PolyJSON mappings (as literal type)
DistributionTypeLiteral = Literal["beta", "binomial", "exponential", "laplace", "lognormal", "normal", "normal_mixture", "pareto", "poisson", "triangular", "weibull", ]


# EOF
