from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..joint_normal.joint_normal import JointNormal, _JointNormal
    from ..kde2d.kde2d import KDE2D, _KDE2D
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.distributions.Distribution2D
Via: com.dataiku.dip.eda.compute.computations.bivariate.Fit2DDistribution
'''


class _Distribution2D(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.distributions.Distribution2D
Distribution2D = Union[
    'JointNormal',
    'KDE2D',
]

# Types of class com.dataiku.dip.eda.compute.distributions.Distribution2D in PolyJSON mappings (as literal type)
Distribution2DTypeLiteral = Literal["joint_normal", "kde_2d", ]


# EOF
