from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...online.llm_client.abstract_tool_call import AbstractToolCall, _AbstractToolCall
    from ...online.llm_client.artifact import Artifact, _Artifact
    from ...online.llm_client.detailed_log_prob import DetailedLogProb, _DetailedLogProb
    from ...online.llm_client.finish_reason import FinishReason
    from .usage_data import UsageData, _UsageData
    from .zero_shot_classification_response import ZeroShotClassificationResponse, _ZeroShotClassificationResponse

'''
Translated from class com.dataiku.dip.llm.local.HuggingFaceKernelClient$ProcessSinglePromptResponse
Via: PyModel annotation in the class hierarchy
'''


class _ProcessSinglePromptResponse(TypedDict):
    artifacts: NotRequired[Optional[List['Artifact']]]
    classification: NotRequired[Optional['ZeroShotClassificationResponse']]
    finishReason: NotRequired[Optional['FinishReason']]
    logProbs: NotRequired[Optional[List['DetailedLogProb']]]
    text: NotRequired[Optional[str]]
    toolCalls: NotRequired[Optional[List['AbstractToolCall']]]
    usage: NotRequired[Optional['UsageData']]


ProcessSinglePromptResponse = _ProcessSinglePromptResponse


# EOF
