/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.plugins.builtinmacros;

import com.dataiku.dip.experimenttracking.ExperimentTrackingGarbageCollectionReport;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRunnable;
import com.dataiku.dip.plugin.ProgressTracker;
import com.dataiku.dip.plugin.ResultTableDTO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class GarbageCollectExperiments
implements CustomRunnable {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private String projectKey;
    private AuthCtx authCtx;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    private static Logger logger = Logger.getLogger((String)"dku.macro.garbagecollectexperiments");

    public void init(String projectKey, JsonObject config, JsonObject pluginConfig, ProgressTracker progressTracker, BackendClient backendClient) {
        this.projectKey = projectKey;
        this.authCtx = (AuthCtx)backendClient.getAuthCtx();
        SpringUtils.getInstance().autowire((Object)this);
    }

    public byte[] run() throws Exception {
        ExperimentTrackingGarbageCollectionReport garbageCollectionReport = this.experimentTrackingService.garbageCollect_NT(this.authCtx, this.projectKey);
        List<ResultTableDTO.ResultTableColumnDTO> columns = Arrays.asList(new ResultTableDTO.ResultTableColumnDTO("Object type", "STRING"), new ResultTableDTO.ResultTableColumnDTO("Number of deleted objects", "STRING"));
        List<List> data = Arrays.asList(Arrays.asList("Experiments", String.valueOf(garbageCollectionReport.numberOfDeletedExperiments)), Arrays.asList("Runs", String.valueOf(garbageCollectionReport.numberOfDeletedRuns)));
        return JSON.json((Object)new ResultTableDTO("Garbage collect experiments", columns, data)).getBytes(StandardCharsets.UTF_8);
    }

    public void abort() {
    }
}

