/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@DynamoDB
@DynamoDBAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBAutoGeneratedDefault {
    public String value();

    public static final class Generator<T>
    extends DynamoDBAutoGenerator.AbstractGenerator<T> {
        private final DynamoDBTypeConverter<T, String> converter;
        private final String defaultValue;

        public Generator(Class<T> targetType, DynamoDBAutoGeneratedDefault annotation) {
            super(DynamoDBAutoGenerateStrategy.CREATE);
            this.converter = StandardTypeConverters.factory().getConverter(targetType, String.class);
            this.defaultValue = annotation.value();
        }

        @Override
        public final T generate(T currentValue) {
            return this.converter.convert(this.defaultValue);
        }
    }
}

