/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.GlueSchema;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.S3DirectSourceAdditionalOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform.S3DeltaSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3DeltaSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> paths;
    private Map<String, String> additionalDeltaOptions;
    private S3DirectSourceAdditionalOptions additionalOptions;
    private List<GlueSchema> outputSchemas;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3DeltaSource withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(Collection<String> paths) {
        if (paths == null) {
            this.paths = null;
            return;
        }
        this.paths = new ArrayList<String>(paths);
    }

    public S3DeltaSource withPaths(String ... paths) {
        if (this.paths == null) {
            this.setPaths(new ArrayList<String>(paths.length));
        }
        for (String ele : paths) {
            this.paths.add(ele);
        }
        return this;
    }

    public S3DeltaSource withPaths(Collection<String> paths) {
        this.setPaths(paths);
        return this;
    }

    public Map<String, String> getAdditionalDeltaOptions() {
        return this.additionalDeltaOptions;
    }

    public void setAdditionalDeltaOptions(Map<String, String> additionalDeltaOptions) {
        this.additionalDeltaOptions = additionalDeltaOptions;
    }

    public S3DeltaSource withAdditionalDeltaOptions(Map<String, String> additionalDeltaOptions) {
        this.setAdditionalDeltaOptions(additionalDeltaOptions);
        return this;
    }

    public S3DeltaSource addAdditionalDeltaOptionsEntry(String key, String value) {
        if (null == this.additionalDeltaOptions) {
            this.additionalDeltaOptions = new HashMap<String, String>();
        }
        if (this.additionalDeltaOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalDeltaOptions.put(key, value);
        return this;
    }

    public S3DeltaSource clearAdditionalDeltaOptionsEntries() {
        this.additionalDeltaOptions = null;
        return this;
    }

    public void setAdditionalOptions(S3DirectSourceAdditionalOptions additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public S3DirectSourceAdditionalOptions getAdditionalOptions() {
        return this.additionalOptions;
    }

    public S3DeltaSource withAdditionalOptions(S3DirectSourceAdditionalOptions additionalOptions) {
        this.setAdditionalOptions(additionalOptions);
        return this;
    }

    public List<GlueSchema> getOutputSchemas() {
        return this.outputSchemas;
    }

    public void setOutputSchemas(Collection<GlueSchema> outputSchemas) {
        if (outputSchemas == null) {
            this.outputSchemas = null;
            return;
        }
        this.outputSchemas = new ArrayList<GlueSchema>(outputSchemas);
    }

    public S3DeltaSource withOutputSchemas(GlueSchema ... outputSchemas) {
        if (this.outputSchemas == null) {
            this.setOutputSchemas(new ArrayList<GlueSchema>(outputSchemas.length));
        }
        for (GlueSchema ele : outputSchemas) {
            this.outputSchemas.add(ele);
        }
        return this;
    }

    public S3DeltaSource withOutputSchemas(Collection<GlueSchema> outputSchemas) {
        this.setOutputSchemas(outputSchemas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPaths() != null) {
            sb.append("Paths: ").append(this.getPaths()).append(",");
        }
        if (this.getAdditionalDeltaOptions() != null) {
            sb.append("AdditionalDeltaOptions: ").append(this.getAdditionalDeltaOptions()).append(",");
        }
        if (this.getAdditionalOptions() != null) {
            sb.append("AdditionalOptions: ").append(this.getAdditionalOptions()).append(",");
        }
        if (this.getOutputSchemas() != null) {
            sb.append("OutputSchemas: ").append(this.getOutputSchemas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DeltaSource)) {
            return false;
        }
        S3DeltaSource other = (S3DeltaSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPaths() == null ^ this.getPaths() == null) {
            return false;
        }
        if (other.getPaths() != null && !other.getPaths().equals(this.getPaths())) {
            return false;
        }
        if (other.getAdditionalDeltaOptions() == null ^ this.getAdditionalDeltaOptions() == null) {
            return false;
        }
        if (other.getAdditionalDeltaOptions() != null && !other.getAdditionalDeltaOptions().equals(this.getAdditionalDeltaOptions())) {
            return false;
        }
        if (other.getAdditionalOptions() == null ^ this.getAdditionalOptions() == null) {
            return false;
        }
        if (other.getAdditionalOptions() != null && !other.getAdditionalOptions().equals(this.getAdditionalOptions())) {
            return false;
        }
        if (other.getOutputSchemas() == null ^ this.getOutputSchemas() == null) {
            return false;
        }
        return other.getOutputSchemas() == null || other.getOutputSchemas().equals(this.getOutputSchemas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPaths() == null ? 0 : this.getPaths().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalDeltaOptions() == null ? 0 : this.getAdditionalDeltaOptions().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOptions() == null ? 0 : this.getAdditionalOptions().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSchemas() == null ? 0 : this.getOutputSchemas().hashCode());
        return hashCode;
    }

    public S3DeltaSource clone() {
        try {
            return (S3DeltaSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DeltaSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

