/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DataSource;

@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3DATASOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataSource").build();
    private static final MarshallingInfo<StructuredPojo> FILESYSTEMDATASOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemDataSource").build();
    private static final DataSourceMarshaller instance = new DataSourceMarshaller();

    public static DataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        if (dataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataSource.getS3DataSource(), S3DATASOURCE_BINDING);
            protocolMarshaller.marshall(dataSource.getFileSystemDataSource(), FILESYSTEMDATASOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

