/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.client.transport.jsonrpc;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.type.TypeReference;
import com.dataiku.dss.shadeliba2a.io.a2a.client.http.A2ACardResolver;
import com.dataiku.dss.shadeliba2a.io.a2a.client.http.A2AHttpClient;
import com.dataiku.dss.shadeliba2a.io.a2a.client.http.A2AHttpResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.client.http.JdkA2AHttpClient;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.jsonrpc.sse.SSEEventListener;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.ClientTransport;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.ClientCallContext;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.ClientCallInterceptor;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.PayloadAndHeaders;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientException;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCard;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.CancelTaskRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.CancelTaskResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.DeleteTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.DeleteTaskPushNotificationConfigResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.EventKind;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetAuthenticatedExtendedCardRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetAuthenticatedExtendedCardResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskPushNotificationConfigResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ListTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ListTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ListTaskPushNotificationConfigResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.MessageSendParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendMessageRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendMessageResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendStreamingMessageRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SetTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SetTaskPushNotificationConfigResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.StreamingEventKind;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Task;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskIdParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskPushNotificationConfig;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskQueryParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskResubscriptionRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Assert;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class JSONRPCTransport
implements ClientTransport {
    private static final TypeReference<SendMessageResponse> SEND_MESSAGE_RESPONSE_REFERENCE = new TypeReference<SendMessageResponse>(){};
    private static final TypeReference<GetTaskResponse> GET_TASK_RESPONSE_REFERENCE = new TypeReference<GetTaskResponse>(){};
    private static final TypeReference<CancelTaskResponse> CANCEL_TASK_RESPONSE_REFERENCE = new TypeReference<CancelTaskResponse>(){};
    private static final TypeReference<GetTaskPushNotificationConfigResponse> GET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE = new TypeReference<GetTaskPushNotificationConfigResponse>(){};
    private static final TypeReference<SetTaskPushNotificationConfigResponse> SET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE = new TypeReference<SetTaskPushNotificationConfigResponse>(){};
    private static final TypeReference<ListTaskPushNotificationConfigResponse> LIST_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE = new TypeReference<ListTaskPushNotificationConfigResponse>(){};
    private static final TypeReference<DeleteTaskPushNotificationConfigResponse> DELETE_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE = new TypeReference<DeleteTaskPushNotificationConfigResponse>(){};
    private static final TypeReference<GetAuthenticatedExtendedCardResponse> GET_AUTHENTICATED_EXTENDED_CARD_RESPONSE_REFERENCE = new TypeReference<GetAuthenticatedExtendedCardResponse>(){};
    private final A2AHttpClient httpClient;
    private final String agentUrl;
    private final List<ClientCallInterceptor> interceptors;
    private AgentCard agentCard;
    private boolean needsExtendedCard = false;

    public JSONRPCTransport(String agentUrl) {
        this(null, null, agentUrl, null);
    }

    public JSONRPCTransport(AgentCard agentCard) {
        this(null, agentCard, agentCard.url(), null);
    }

    public JSONRPCTransport(A2AHttpClient httpClient, AgentCard agentCard, String agentUrl, List<ClientCallInterceptor> interceptors) {
        this.httpClient = httpClient == null ? new JdkA2AHttpClient() : httpClient;
        this.agentCard = agentCard;
        this.agentUrl = agentUrl;
        this.interceptors = interceptors;
        this.needsExtendedCard = agentCard == null || agentCard.supportsAuthenticatedExtendedCard();
    }

    @Override
    public EventKind sendMessage(MessageSendParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        SendMessageRequest sendMessageRequest = new SendMessageRequest.Builder().jsonrpc("2.0").method("message/send").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("message/send", sendMessageRequest, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
            SendMessageResponse response = this.unmarshalResponse(httpResponseBody, SEND_MESSAGE_RESPONSE_REFERENCE);
            return (EventKind)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to send message: " + String.valueOf(e), e);
        }
    }

    @Override
    public void sendMessageStreaming(MessageSendParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        Assert.checkNotNullParam("eventConsumer", eventConsumer);
        SendStreamingMessageRequest sendStreamingMessageRequest = new SendStreamingMessageRequest.Builder().jsonrpc("2.0").method("message/stream").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("message/stream", sendStreamingMessageRequest, this.agentCard, context);
        AtomicReference<CompletableFuture<Void>> ref = new AtomicReference<CompletableFuture<Void>>();
        SSEEventListener sseEventListener = new SSEEventListener(eventConsumer, errorConsumer);
        try {
            A2AHttpClient.PostBuilder builder = this.createPostBuilder(payloadAndHeaders);
            ref.set(builder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> sseEventListener.onComplete()));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send streaming message request: " + String.valueOf(e), e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Send streaming message request timed out: " + String.valueOf(e), e);
        }
    }

    @Override
    public Task getTask(TaskQueryParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        GetTaskRequest getTaskRequest = new GetTaskRequest.Builder().jsonrpc("2.0").method("tasks/get").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/get", getTaskRequest, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
            GetTaskResponse response = this.unmarshalResponse(httpResponseBody, GET_TASK_RESPONSE_REFERENCE);
            return (Task)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get task: " + String.valueOf(e), e);
        }
    }

    @Override
    public Task cancelTask(TaskIdParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        CancelTaskRequest cancelTaskRequest = new CancelTaskRequest.Builder().jsonrpc("2.0").method("tasks/cancel").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/cancel", cancelTaskRequest, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
            CancelTaskResponse response = this.unmarshalResponse(httpResponseBody, CANCEL_TASK_RESPONSE_REFERENCE);
            return (Task)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to cancel task: " + String.valueOf(e), e);
        }
    }

    @Override
    public TaskPushNotificationConfig setTaskPushNotificationConfiguration(TaskPushNotificationConfig request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        SetTaskPushNotificationConfigRequest setTaskPushNotificationRequest = new SetTaskPushNotificationConfigRequest.Builder().jsonrpc("2.0").method("tasks/pushNotificationConfig/set").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/set", setTaskPushNotificationRequest, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
            SetTaskPushNotificationConfigResponse response = this.unmarshalResponse(httpResponseBody, SET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE);
            return (TaskPushNotificationConfig)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to set task push notification config: " + String.valueOf(e), e);
        }
    }

    @Override
    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        GetTaskPushNotificationConfigRequest getTaskPushNotificationRequest = new GetTaskPushNotificationConfigRequest.Builder().jsonrpc("2.0").method("tasks/pushNotificationConfig/get").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/get", getTaskPushNotificationRequest, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
            GetTaskPushNotificationConfigResponse response = this.unmarshalResponse(httpResponseBody, GET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE);
            return (TaskPushNotificationConfig)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get task push notification config: " + String.valueOf(e), e);
        }
    }

    @Override
    public List<TaskPushNotificationConfig> listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        ListTaskPushNotificationConfigRequest listTaskPushNotificationRequest = new ListTaskPushNotificationConfigRequest.Builder().jsonrpc("2.0").method("tasks/pushNotificationConfig/list").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/list", listTaskPushNotificationRequest, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
            ListTaskPushNotificationConfigResponse response = this.unmarshalResponse(httpResponseBody, LIST_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE);
            return (List)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to list task push notification configs: " + String.valueOf(e), e);
        }
    }

    @Override
    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        DeleteTaskPushNotificationConfigRequest deleteTaskPushNotificationRequest = new DeleteTaskPushNotificationConfigRequest.Builder().jsonrpc("2.0").method("tasks/pushNotificationConfig/delete").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/delete", deleteTaskPushNotificationRequest, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
            this.unmarshalResponse(httpResponseBody, DELETE_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to delete task push notification configs: " + String.valueOf(e), e);
        }
    }

    @Override
    public void resubscribe(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam("request", request);
        Assert.checkNotNullParam("eventConsumer", eventConsumer);
        Assert.checkNotNullParam("errorConsumer", errorConsumer);
        TaskResubscriptionRequest taskResubscriptionRequest = new TaskResubscriptionRequest.Builder().jsonrpc("2.0").method("tasks/resubscribe").params(request).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/resubscribe", taskResubscriptionRequest, this.agentCard, context);
        AtomicReference<CompletableFuture<Void>> ref = new AtomicReference<CompletableFuture<Void>>();
        SSEEventListener sseEventListener = new SSEEventListener(eventConsumer, errorConsumer);
        try {
            A2AHttpClient.PostBuilder builder = this.createPostBuilder(payloadAndHeaders);
            ref.set(builder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> sseEventListener.onComplete()));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send task resubscription request: " + String.valueOf(e), e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Task resubscription request timed out: " + String.valueOf(e), e);
        }
    }

    @Override
    public AgentCard getAgentCard(ClientCallContext context) throws A2AClientException {
        try {
            if (this.agentCard == null) {
                A2ACardResolver resolver = new A2ACardResolver(this.httpClient, this.agentUrl, null, this.getHttpHeaders(context));
                this.agentCard = resolver.getAgentCard();
                this.needsExtendedCard = this.agentCard.supportsAuthenticatedExtendedCard();
            }
            if (!this.needsExtendedCard) {
                return this.agentCard;
            }
            GetAuthenticatedExtendedCardRequest getExtendedAgentCardRequest = new GetAuthenticatedExtendedCardRequest.Builder().jsonrpc("2.0").method("agent/getAuthenticatedExtendedCard").build();
            PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("agent/getAuthenticatedExtendedCard", getExtendedAgentCardRequest, this.agentCard, context);
            try {
                String httpResponseBody = this.sendPostRequest(payloadAndHeaders);
                GetAuthenticatedExtendedCardResponse response = this.unmarshalResponse(httpResponseBody, GET_AUTHENTICATED_EXTENDED_CARD_RESPONSE_REFERENCE);
                this.agentCard = (AgentCard)response.getResult();
                this.needsExtendedCard = false;
                return this.agentCard;
            }
            catch (IOException | InterruptedException e) {
                throw new A2AClientException("Failed to get authenticated extended agent card: " + String.valueOf(e), e);
            }
        }
        catch (A2AClientError e) {
            throw new A2AClientException("Failed to get agent card: " + String.valueOf(e), e);
        }
    }

    @Override
    public void close() {
    }

    private PayloadAndHeaders applyInterceptors(String methodName, Object payload, AgentCard agentCard, ClientCallContext clientCallContext) {
        PayloadAndHeaders payloadAndHeaders = new PayloadAndHeaders(payload, this.getHttpHeaders(clientCallContext));
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (ClientCallInterceptor interceptor : this.interceptors) {
                payloadAndHeaders = interceptor.intercept(methodName, payloadAndHeaders.getPayload(), payloadAndHeaders.getHeaders(), agentCard, clientCallContext);
            }
        }
        return payloadAndHeaders;
    }

    private String sendPostRequest(PayloadAndHeaders payloadAndHeaders) throws IOException, InterruptedException {
        A2AHttpClient.PostBuilder builder = this.createPostBuilder(payloadAndHeaders);
        A2AHttpResponse response = builder.post();
        if (!response.success()) {
            throw new IOException("Request failed " + response.status());
        }
        return response.body();
    }

    private A2AHttpClient.PostBuilder createPostBuilder(PayloadAndHeaders payloadAndHeaders) throws JsonProcessingException {
        A2AHttpClient.PostBuilder postBuilder = ((A2AHttpClient.PostBuilder)((A2AHttpClient.PostBuilder)this.httpClient.createPost().url(this.agentUrl)).addHeader("Content-Type", "application/json")).body(Utils.OBJECT_MAPPER.writeValueAsString(payloadAndHeaders.getPayload()));
        if (payloadAndHeaders.getHeaders() != null) {
            for (Map.Entry<String, String> entry : payloadAndHeaders.getHeaders().entrySet()) {
                postBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return postBuilder;
    }

    private <T extends JSONRPCResponse<?>> T unmarshalResponse(String response, TypeReference<T> typeReference) throws A2AClientException, JsonProcessingException {
        JSONRPCResponse value = (JSONRPCResponse)Utils.unmarshalFrom(response, typeReference);
        JSONRPCError error = value.getError();
        if (error != null) {
            throw new A2AClientException(error.getMessage() + (String)(error.getData() != null ? ": " + String.valueOf(error.getData()) : ""), error);
        }
        return (T)value;
    }

    private Map<String, String> getHttpHeaders(ClientCallContext context) {
        return context != null ? context.getHeaders() : null;
    }
}

