/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.auth;

import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.ClientCallContext;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.ClientCallInterceptor;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.PayloadAndHeaders;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.auth.CredentialService;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.APIKeySecurityScheme;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCard;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.HTTPAuthSecurityScheme;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.OAuth2SecurityScheme;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.OpenIdConnectSecurityScheme;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SecurityScheme;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class AuthInterceptor
extends ClientCallInterceptor {
    private static final String BEARER_SCHEME = "bearer";
    public static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private final CredentialService credentialService;

    public AuthInterceptor(CredentialService credentialService) {
        this.credentialService = credentialService;
    }

    @Override
    public PayloadAndHeaders intercept(String methodName, @Nullable Object payload, Map<String, String> headers, AgentCard agentCard, @Nullable ClientCallContext clientCallContext) {
        HashMap<String, String> updatedHeaders = new HashMap<String, String>(headers == null ? new HashMap() : headers);
        if (agentCard == null || agentCard.security() == null || agentCard.securitySchemes() == null) {
            return new PayloadAndHeaders(payload, updatedHeaders);
        }
        for (Map<String, List<String>> requirement : agentCard.security()) {
            for (String securitySchemeName : requirement.keySet()) {
                SecurityScheme securityScheme;
                String credential = this.credentialService.getCredential(securitySchemeName, clientCallContext);
                if (credential == null || !agentCard.securitySchemes().containsKey(securitySchemeName) || (securityScheme = agentCard.securitySchemes().get(securitySchemeName)) == null) continue;
                if (securityScheme instanceof HTTPAuthSecurityScheme) {
                    HTTPAuthSecurityScheme httpAuthSecurityScheme = (HTTPAuthSecurityScheme)securityScheme;
                    if (!httpAuthSecurityScheme.getScheme().toLowerCase(Locale.ROOT).equals(BEARER_SCHEME)) continue;
                    updatedHeaders.put(AUTHORIZATION, AuthInterceptor.getBearerValue(credential));
                    return new PayloadAndHeaders(payload, updatedHeaders);
                }
                if (securityScheme instanceof OAuth2SecurityScheme || securityScheme instanceof OpenIdConnectSecurityScheme) {
                    updatedHeaders.put(AUTHORIZATION, AuthInterceptor.getBearerValue(credential));
                    return new PayloadAndHeaders(payload, updatedHeaders);
                }
                if (!(securityScheme instanceof APIKeySecurityScheme)) continue;
                APIKeySecurityScheme apiKeySecurityScheme = (APIKeySecurityScheme)securityScheme;
                updatedHeaders.put(apiKeySecurityScheme.getName(), credential);
                return new PayloadAndHeaders(payload, updatedHeaders);
            }
        }
        return new PayloadAndHeaders(payload, updatedHeaders);
    }

    private static String getBearerValue(String credential) {
        return BEARER + credential;
    }
}

