/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.auth;

import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.ClientCallContext;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.auth.CredentialService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;

public class InMemoryContextCredentialService
implements CredentialService {
    private static final String SESSION_ID = "sessionId";
    private final ConcurrentMap<String, ConcurrentMap<String, String>> credentialStore = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();

    @Override
    public @Nullable String getCredential(String securitySchemeName, @Nullable ClientCallContext clientCallContext) {
        if (clientCallContext == null || !clientCallContext.getState().containsKey(SESSION_ID)) {
            return null;
        }
        Object sessionIdObj = clientCallContext.getState().get(SESSION_ID);
        if (!(sessionIdObj instanceof String)) {
            return null;
        }
        String sessionId = (String)sessionIdObj;
        Map sessionCredentials = (Map)this.credentialStore.get(sessionId);
        if (sessionCredentials == null) {
            return null;
        }
        return (String)sessionCredentials.get(securitySchemeName);
    }

    public void setCredential(String sessionId, String securitySchemeName, String credential) {
        this.credentialStore.computeIfAbsent(sessionId, k -> new ConcurrentHashMap()).put(securitySchemeName, credential);
    }
}

