/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.mutiny.zero.internal;

import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.Helper;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class CompletionStagePublisher<T>
implements Flow.Publisher<T> {
    private final Supplier<CompletionStage<T>> completionStageSupplier;

    public CompletionStagePublisher(Supplier<CompletionStage<T>> completionStageSupplier) {
        this.completionStageSupplier = completionStageSupplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        subscriber.onSubscribe(new CompletionStageSubscription<T>(this.completionStageSupplier, subscriber));
    }

    private static class CompletionStageSubscription<T>
    implements Flow.Subscription {
        private final Supplier<CompletionStage<T>> completionStageSupplier;
        private final Flow.Subscriber<? super T> subscriber;
        private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
        private CompletableFuture<T> completableFuture;

        public CompletionStageSubscription(Supplier<CompletionStage<T>> completionStageSupplier, Flow.Subscriber<? super T> subscriber) {
            this.completionStageSupplier = completionStageSupplier;
            this.subscriber = subscriber;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.cancel();
                this.subscriber.onError(Helper.negativeRequest(n));
                return;
            }
            if (this.state.compareAndSet(State.INIT, State.ACTIVE)) {
                CompletionStage<T> cs = this.completionStageSupplier.get();
                if (cs == null) {
                    this.state.set(State.DONE);
                    this.subscriber.onError(new NullPointerException("The completion stage is null"));
                    return;
                }
                this.completableFuture = cs.toCompletableFuture();
                this.completableFuture.whenComplete((value, err) -> {
                    if (this.state.getAndSet(State.DONE) == State.ACTIVE) {
                        if (err != null) {
                            this.subscriber.onError((Throwable)err);
                        } else if (value == null) {
                            this.subscriber.onError(new NullPointerException("The CompletionStage produced a null value"));
                        } else {
                            this.subscriber.onNext(value);
                            this.subscriber.onComplete();
                        }
                    }
                });
            }
        }

        @Override
        public void cancel() {
            if (this.state.getAndSet(State.DONE) != State.DONE && this.completableFuture != null) {
                this.completableFuture.cancel(false);
            }
        }

        static enum State {
            INIT,
            ACTIVE,
            DONE;

        }
    }
}

