/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.mutiny.zero.operators;

import com.dataiku.dss.shadeliba2a.mutiny.zero.operators.ProcessorBase;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Predicate;

public class Select<T>
implements Flow.Publisher<T> {
    private final Flow.Publisher<T> upstream;
    private final Predicate<T> predicate;

    public Select(Flow.Publisher<T> upstream, Predicate<T> predicate) {
        this.upstream = Objects.requireNonNull(upstream, "The upstream cannot be null");
        this.predicate = Objects.requireNonNull(predicate, "The predicate cannot be null");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Processor processor = new Processor();
        processor.subscribe(subscriber);
        this.upstream.subscribe(processor);
    }

    private class Processor
    extends ProcessorBase<T, T> {
        private Processor() {
        }

        @Override
        public void onNext(T item) {
            if (!this.cancelled()) {
                try {
                    if (Select.this.predicate.test(item)) {
                        this.downstream().onNext(item);
                    } else {
                        this.upstreamSubscription().request(1L);
                    }
                }
                catch (Throwable failure) {
                    this.cancel();
                    this.downstream().onError(failure);
                }
            }
        }
    }
}

