/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.text.SimpleDateFormat;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.SystemUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.StreamReadConstraints;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.MapperFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class ObjectMapperFactory {
    private static final SFLogger log = SFLoggerFactory.getLogger(ObjectMapperFactory.class);
    @SnowflakeJdbcInternalApi
    public static final int DEFAULT_MAX_JSON_STRING_LEN = 180000000;
    @SnowflakeJdbcInternalApi
    public static final String MAX_JSON_STRING_LENGTH_JVM = "net.snowflake.jdbc.objectMapper.maxJsonStringLength";

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS, false);
        mapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, false);
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        int maxJsonStringLength = SystemUtil.convertSystemPropertyToIntValue(MAX_JSON_STRING_LENGTH_JVM, 180000000);
        mapper.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxJsonStringLength).build());
        return mapper;
    }

    @SnowflakeJdbcInternalApi
    public static ObjectMapper getObjectMapperForSession(SFBaseSession session) {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        if (session != null && session.getCommonParameters() != null) {
            Object dateOutputFormat = session.getCommonParameters().get("DATE_OUTPUT_FORMAT");
            if (dateOutputFormat != null) {
                mapper.setDateFormat(new SimpleDateFormat(String.valueOf(dateOutputFormat)));
            } else {
                log.debug("DATE_OUTPUT_FORMAT is not set in session parameters.", new Object[0]);
            }
        } else {
            log.debug("Initialized object mapper without session or parameter settings.", new Object[0]);
        }
        return mapper;
    }
}

