/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.List;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFJsonResultSet;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFixedView;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFFixedViewResultSet
extends SFJsonResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFFixedViewResultSet.class);
    private SnowflakeFixedView fixedView;
    private Object[] nextRow = null;
    private final SFBaseFileTransferAgent.CommandType commandType;
    private final String queryID;

    public SFFixedViewResultSet(SnowflakeFixedView fixedView, SFBaseFileTransferAgent.CommandType commandType, String queryID) throws SnowflakeSQLException {
        super(null, new Converters(null, new SFSession(), 0L, false, false, false, false, SFBinaryFormat.BASE64, null, null, null, null, null));
        this.fixedView = fixedView;
        this.commandType = commandType;
        this.queryID = queryID;
        try {
            this.resultSetMetaData = new SFResultSetMetaData(fixedView.describeColumns(this.session), this.session, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.dateFormatter, this.timeFormatter);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLLoggedException(queryID, this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to describe fixed view: " + fixedView.getClass().getName());
        }
    }

    @Override
    public boolean next() throws SFException {
        List<Object> nextRowList;
        logger.trace("next called", false);
        try {
            nextRowList = this.fixedView.getNextRow();
        }
        catch (Exception ex) {
            throw new SFException(this.queryID, ErrorCode.INTERNAL_ERROR, IncidentUtil.oneLiner("Error getting next row from fixed view:", ex));
        }
        ++this.row;
        if (nextRowList == null) {
            logger.debug("End of result", false);
            return false;
        }
        if (this.nextRow == null) {
            this.nextRow = new Object[nextRowList.size()];
        }
        this.nextRow = nextRowList.toArray(this.nextRow);
        return true;
    }

    @Override
    protected Object getObjectInternal(int columnIndex) throws SFException {
        logger.trace("Object getObjectInternal(int columnIndex)", false);
        if (this.nextRow == null) {
            throw new SFException(this.queryID, ErrorCode.ROW_DOES_NOT_EXIST, new Object[0]);
        }
        if (columnIndex <= 0 || columnIndex > this.nextRow.length) {
            throw new SFException(this.queryID, ErrorCode.COLUMN_DOES_NOT_EXIST, columnIndex);
        }
        this.wasNull = this.nextRow[columnIndex - 1] == null;
        return this.nextRow[columnIndex - 1];
    }

    @Override
    public void close() throws SnowflakeSQLException {
        super.close();
        this.nextRow = null;
        this.fixedView = null;
    }

    @Override
    public SFStatementType getStatementType() {
        if (this.commandType == SFBaseFileTransferAgent.CommandType.DOWNLOAD) {
            return SFStatementType.GET;
        }
        return SFStatementType.PUT;
    }

    @Override
    public void setStatementType(SFStatementType statementType) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean isLast() {
        return this.row == this.fixedView.getTotalRows();
    }

    @Override
    public boolean isAfterLast() {
        return this.row > this.fixedView.getTotalRows();
    }

    @Override
    public String getQueryId() {
        return this.queryID;
    }
}

