/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpExecutingContext;
import net.snowflake.client.core.HttpExecutingContextBuilder;
import net.snowflake.client.core.HttpResponseContextDto;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFOCSPException;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.URLUtil;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.HttpHeadersCustomizer;
import net.snowflake.client.jdbc.OCSPErrorCode;
import net.snowflake.client.jdbc.RetryContextManager;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUseDPoPNonceException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.StatusLine;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.DecorrelatedJitterBackoff;
import net.snowflake.client.util.SecretDetector;
import net.snowflake.client.util.Stopwatch;

public class RestRequest {
    private static final SFLogger logger = SFLoggerFactory.getLogger(RestRequest.class);
    private static final String SF_REQUEST_GUID = "request_guid";
    private static final long minBackoffInMilli = 1000L;
    private static final long maxBackoffInMilli = 16000L;
    private static final int MIN_RETRY_COUNT = 1;
    static final String ERROR_FIELD_NAME = "error";
    static final String ERROR_USE_DPOP_NONCE = "use_dpop_nonce";
    static final String DPOP_NONCE_HEADER_NAME = "dpop-nonce";
    static final Set<Class<?>> sslExceptions = new HashSet<Class>(Arrays.asList(SSLHandshakeException.class, SSLKeyException.class, SSLPeerUnverifiedException.class, SSLProtocolException.class));

    @Deprecated
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, ExecTimeTelemetryData execTimeTelemetryData) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, execTimeTelemetryData, (SFBaseSession)null);
    }

    @SnowflakeJdbcInternalApi
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, ExecTimeTelemetryData execTimeTelemetryData, SFBaseSession sfSession) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, false, execTimeTelemetryData, null, sfSession, null, null, false);
    }

    @Deprecated
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, boolean noRetry, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, noRetry, execTimeData, (SFBaseSession)null);
    }

    @SnowflakeJdbcInternalApi
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, boolean noRetry, ExecTimeTelemetryData execTimeData, SFBaseSession sfSession) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, noRetry, execTimeData, null, sfSession, null, null, false);
    }

    @Deprecated
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, ExecTimeTelemetryData execTimeData, RetryContextManager retryContextManager) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, execTimeData, retryContextManager, null);
    }

    @SnowflakeJdbcInternalApi
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, ExecTimeTelemetryData execTimeData, RetryContextManager retryContextManager, SFBaseSession sfSession) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, false, execTimeData, retryContextManager, sfSession, null, null, false);
    }

    @Deprecated
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, boolean noRetry, ExecTimeTelemetryData execTimeData, RetryContextManager retryManager) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, noRetry, execTimeData, retryManager, null, null, null, false);
    }

    @SnowflakeJdbcInternalApi
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, boolean noRetry, ExecTimeTelemetryData execTimeData, RetryContextManager retryManager, SFBaseSession sfSession, HttpClientSettingsKey key, List<HttpHeadersCustomizer> httpHeaderCustomizer, boolean isHttpClientWithoutDecompression) throws SnowflakeSQLException {
        return RestRequest.executeWithRetries(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, noRetry, new ExecTimeTelemetryData(), sfSession, key, httpHeaderCustomizer, isHttpClientWithoutDecompression).getHttpResponse();
    }

    static long getNewBackoffInMilli(long previousBackoffInMilli, boolean isLoginRequest, DecorrelatedJitterBackoff decorrelatedJitterBackoff, int retryCount, long retryTimeoutInMilliseconds, long elapsedMilliForTransientIssues) {
        long backoffInMilli;
        if (isLoginRequest) {
            long jitteredBackoffInMilli = decorrelatedJitterBackoff.getJitterForLogin(previousBackoffInMilli);
            backoffInMilli = (long)decorrelatedJitterBackoff.chooseRandom(jitteredBackoffInMilli + previousBackoffInMilli, Math.pow(2.0, retryCount) + (double)jitteredBackoffInMilli);
        } else {
            backoffInMilli = decorrelatedJitterBackoff.nextSleepTime(previousBackoffInMilli);
        }
        backoffInMilli = Math.min(16000L, Math.max(previousBackoffInMilli, backoffInMilli));
        if (retryTimeoutInMilliseconds > 0L && elapsedMilliForTransientIssues + backoffInMilli > retryTimeoutInMilliseconds) {
            backoffInMilli = Math.max(0L, Math.min(backoffInMilli, retryTimeoutInMilliseconds - elapsedMilliForTransientIssues));
            logger.debug("We are approaching retry timeout {}ms, setting backoff to {}ms", retryTimeoutInMilliseconds, backoffInMilli);
        }
        return backoffInMilli;
    }

    static boolean isNonRetryableHTTPCode(CloseableHttpResponse response, boolean retryHTTP403) {
        return !(response == null || response.getStatusLine().getStatusCode() >= 500 && response.getStatusLine().getStatusCode() < 600 || response.getStatusLine().getStatusCode() == 408 || response.getStatusLine().getStatusCode() == 429 || retryHTTP403 && response.getStatusLine().getStatusCode() == 403);
    }

    private static boolean isCertificateRevoked(Exception ex) {
        if (ex == null) {
            return false;
        }
        Throwable ex0 = RestRequest.getRootCause(ex);
        if (!(ex0 instanceof SFOCSPException)) {
            return false;
        }
        SFOCSPException cause = (SFOCSPException)ex0;
        return cause.getErrorCode() == OCSPErrorCode.CERTIFICATE_STATUS_REVOKED;
    }

    private static Throwable getRootCause(Throwable ex) {
        Throwable ex0 = ex;
        while (ex0.getCause() != null) {
            ex0 = ex0.getCause();
        }
        return ex0;
    }

    private static void setRequestConfig(HttpRequestBase httpRequest, boolean withoutCookies, int injectSocketTimeout, String requestIdStr, long authTimeoutInMilli) {
        if (withoutCookies) {
            httpRequest.setConfig(HttpUtil.getRequestConfigWithoutCookies());
        }
        if (injectSocketTimeout != 0) {
            logger.debug("{}Injecting socket timeout by setting socket timeout to {} ms", requestIdStr, injectSocketTimeout);
            httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(injectSocketTimeout, withoutCookies));
        }
        if (authTimeoutInMilli > 0L) {
            int requestSocketAndConnectTimeout = (int)authTimeoutInMilli;
            logger.debug("{}Setting auth timeout as the socket timeout: {} ms", requestIdStr, authTimeoutInMilli);
            httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketAndConnectTimeout(requestSocketAndConnectTimeout, withoutCookies));
        }
    }

    private static void setRequestURI(HttpRequestBase httpRequest, String requestIdStr, boolean includeRetryParameters, boolean includeSnowflakeHeaders, int retryCount, String lastStatusCodeForRetry, long startTime, String requestInfoScrubbed) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(httpRequest.getURI());
        if ("true".equalsIgnoreCase(System.getenv("HTAP_SIMULATION")) && builder.getPathSegments().contains("query-request")) {
            logger.debug("{}Setting htap simulation", requestIdStr);
            builder.setParameter("target", "htap_simulation");
        }
        if (includeRetryParameters && retryCount > 0) {
            RestRequest.updateRetryParameters(builder, retryCount, lastStatusCodeForRetry, startTime);
        }
        if (includeSnowflakeHeaders) {
            UUID guid = UUIDUtils.getUUID();
            logger.debug("{}Request {} guid: {}", requestIdStr, requestInfoScrubbed, guid.toString());
            builder.setParameter(SF_REQUEST_GUID, guid.toString());
        }
        httpRequest.setURI(builder.build());
    }

    @SnowflakeJdbcInternalApi
    public static HttpResponseContextDto executeWithRetries(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, boolean unpackResponse, ExecTimeTelemetryData execTimeTelemetryData, SFBaseSession sfSession, HttpClientSettingsKey key, List<HttpHeadersCustomizer> httpHeaderCustomizer, boolean isHttpClientWithoutDecompression) throws SnowflakeSQLException {
        return RestRequest.executeWithRetries(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeSnowflakeHeaders, retryHTTP403, false, unpackResponse, execTimeTelemetryData, sfSession, key, httpHeaderCustomizer, isHttpClientWithoutDecompression);
    }

    @SnowflakeJdbcInternalApi
    public static HttpResponseContextDto executeWithRetries(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeSnowflakeHeaders, boolean retryHTTP403, boolean noRetry, boolean unpackResponse, ExecTimeTelemetryData execTimeTelemetryData, SFBaseSession sfSession, HttpClientSettingsKey key, List<HttpHeadersCustomizer> httpHeaderCustomizer, boolean isHttpClientWithoutDecompression) throws SnowflakeSQLException {
        String requestIdStr = URLUtil.getRequestIdLogStr(httpRequest.getURI());
        String requestInfoScrubbed = SecretDetector.maskSASToken(httpRequest.toString());
        HttpExecutingContext context = HttpExecutingContextBuilder.withRequest(requestIdStr, requestInfoScrubbed).retryTimeout(retryTimeout).authTimeout(authTimeout).origSocketTimeout(socketTimeout).maxRetries(maxRetries).injectSocketTimeout(injectSocketTimeout).canceling(canceling).withoutCookies(withoutCookies).includeRetryParameters(includeRetryParameters).includeSnowflakeHeaders(includeSnowflakeHeaders).retryHTTP403(retryHTTP403).noRetry(noRetry).unpackResponse(unpackResponse).loginRequest(SessionUtil.isNewRetryStrategyRequest(httpRequest)).withSfSession(sfSession).build();
        return RestRequest.executeWithRetries(httpClient, httpRequest, context, execTimeTelemetryData, null, key, httpHeaderCustomizer, isHttpClientWithoutDecompression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SnowflakeJdbcInternalApi
    public static HttpResponseContextDto executeWithRetries(CloseableHttpClient httpClient, HttpRequestBase httpRequest, HttpExecutingContext httpExecutingContext, ExecTimeTelemetryData execTimeData, RetryContextManager retryManager, HttpClientSettingsKey key, List<HttpHeadersCustomizer> httpHeaderCustomizer, boolean isHttpClientWithoutDecompression) throws SnowflakeSQLException {
        Stopwatch networkComunnicationStapwatch = null;
        Object requestReponseStopWatch = null;
        HttpResponseContextDto responseDto = new HttpResponseContextDto();
        if (logger.isDebugEnabled()) {
            networkComunnicationStapwatch = new Stopwatch();
            networkComunnicationStapwatch.start();
            logger.debug("{}Executing rest request: {}, retry timeout: {}, socket timeout: {}, max retries: {}, inject socket timeout: {}, canceling: {}, without cookies: {}, include retry parameters: {}, include request guid: {}, retry http 403: {}, no retry: {}", httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed(), httpExecutingContext.getRetryTimeoutInMilliseconds(), httpExecutingContext.getOrigSocketTimeout(), httpExecutingContext.getMaxRetries(), httpExecutingContext.isInjectSocketTimeout(), httpExecutingContext.getCanceling(), httpExecutingContext.isWithoutCookies(), httpExecutingContext.isIncludeRetryParameters(), httpExecutingContext.isIncludeSnowflakeHeaders(), httpExecutingContext.isRetryHTTP403(), httpExecutingContext.isNoRetry());
        }
        if (httpExecutingContext.isLoginRequest()) {
            logger.debug("{}Request is a login/auth request. Using new retry strategy", httpExecutingContext.getRequestId());
        }
        RestRequest.setRequestConfig(httpRequest, httpExecutingContext.isWithoutCookies(), httpExecutingContext.getInjectSocketTimeout(), httpExecutingContext.getRequestId(), httpExecutingContext.getAuthTimeoutInMilliseconds());
        while (true) {
            logger.debug("{}Retry count: {}, max retries: {}, retry timeout: {} s, backoff: {} ms. Attempting request: {}", httpExecutingContext.getRequestId(), httpExecutingContext.getRetryCount(), httpExecutingContext.getMaxRetries(), httpExecutingContext.getRetryTimeout(), httpExecutingContext.getMinBackoffInMillis(), httpExecutingContext.getRequestInfoScrubbed());
            try {
                httpExecutingContext.setStartTimePerRequest(System.currentTimeMillis());
                RestRequest.setRequestURI(httpRequest, httpExecutingContext.getRequestId(), httpExecutingContext.isIncludeRetryParameters(), httpExecutingContext.isIncludeSnowflakeHeaders(), httpExecutingContext.getRetryCount(), httpExecutingContext.getLastStatusCodeForRetry(), httpExecutingContext.getStartTime(), httpExecutingContext.getRequestInfoScrubbed());
                SFBaseSession session = httpExecutingContext.getSfSession();
                if (httpExecutingContext.isIncludeSnowflakeHeaders() && session != null && session.getStickyHttpHeaders() != null) {
                    for (Map.Entry<String, String> entry : session.getStickyHttpHeaders().entrySet()) {
                        httpRequest.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                execTimeData.setHttpClientStart();
                CloseableHttpResponse response = httpClient.execute(httpRequest);
                responseDto.setHttpResponse(response);
                execTimeData.setHttpClientEnd();
            }
            catch (Exception ex) {
                if (ex instanceof IllegalStateException) {
                    logger.warn("IllegalStateException encountered while processing the HTTP request. The HttpClient was shut down due to connection closure. Attempting to rebuild the HttpClient and retry the request.", new Object[0]);
                    HttpUtil.httpClient.remove(key);
                    if (isHttpClientWithoutDecompression) {
                        httpClient = HttpUtil.getHttpClientWithoutDecompression(key, httpHeaderCustomizer);
                        continue;
                    }
                    httpClient = HttpUtil.getHttpClient(key, httpHeaderCustomizer);
                    continue;
                }
                responseDto.setSavedEx(RestRequest.handlingNotRetryableException(ex, httpExecutingContext));
            }
            finally {
                if (httpExecutingContext.getInjectSocketTimeout() == 0 || httpExecutingContext.getRetryCount() != 0) continue;
                httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(httpExecutingContext.getOrigSocketTimeout(), httpExecutingContext.isWithoutCookies()));
                continue;
            }
            boolean shouldSkipRetry = RestRequest.shouldSkipRetryWithLoggedReason(httpRequest, responseDto, httpExecutingContext);
            httpExecutingContext.setShouldRetry(!shouldSkipRetry);
            if (httpExecutingContext.isUnpackResponse() && responseDto.getHttpResponse() != null && responseDto.getHttpResponse().getStatusLine().getStatusCode() == 200) {
                RestRequest.processHttpResponse(httpExecutingContext, execTimeData, responseDto);
            }
            if (!httpExecutingContext.isShouldRetry()) {
                if (responseDto.getHttpResponse() == null) {
                    if (responseDto.getSavedEx() != null) {
                        logger.error("{}Returning null response. Cause: {}, request: {}", httpExecutingContext.getRequestId(), RestRequest.getRootCause(responseDto.getSavedEx()), httpExecutingContext.getRequestInfoScrubbed());
                        break;
                    }
                    logger.error("{}Returning null response for request: {}", httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed());
                    break;
                }
                if (responseDto.getHttpResponse().getStatusLine().getStatusCode() != 200) {
                    logger.error("{}Error response: HTTP Response code: {}, request: {}", httpExecutingContext.getRequestId(), responseDto.getHttpResponse().getStatusLine().getStatusCode(), httpExecutingContext.getRequestInfoScrubbed());
                    responseDto.setSavedEx(new SnowflakeSQLException("58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "HTTP status=" + (responseDto.getHttpResponse() != null ? Integer.valueOf(responseDto.getHttpResponse().getStatusLine().getStatusCode()) : "null response")));
                    break;
                }
                if (responseDto.getHttpResponse() != null && responseDto.getHttpResponse().getStatusLine().getStatusCode() == 200) break;
                RestRequest.sendTelemetryEvent(httpRequest, httpExecutingContext, responseDto.getHttpResponse(), responseDto.getSavedEx());
                break;
            }
            RestRequest.prepareRetry(httpRequest, httpExecutingContext, retryManager, responseDto);
        }
        logger.debug("{}Execution of request {} took {} ms with total of {} retries", httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed(), networkComunnicationStapwatch == null ? "n/a" : Long.valueOf(networkComunnicationStapwatch.elapsedMillis()), httpExecutingContext.getRetryCount());
        httpExecutingContext.resetRetryCount();
        if (logger.isDebugEnabled() && networkComunnicationStapwatch != null) {
            networkComunnicationStapwatch.stop();
        }
        if (responseDto.getSavedEx() != null) {
            Exception savedEx = responseDto.getSavedEx();
            RestRequest.sendIBHttpErrorEvent(httpRequest, responseDto.getHttpResponse(), httpExecutingContext);
            if (savedEx instanceof SnowflakeSQLException) {
                throw (SnowflakeSQLException)savedEx;
            }
            throw new SnowflakeSQLException((Throwable)savedEx, ErrorCode.NETWORK_ERROR, "Exception encountered for HTTP request: " + savedEx.getMessage());
        }
        return responseDto;
    }

    private static void processHttpResponse(HttpExecutingContext httpExecutingContext, ExecTimeTelemetryData execTimeData, HttpResponseContextDto responseDto) {
        CloseableHttpResponse response = responseDto.getHttpResponse();
        try {
            String responseText = RestRequest.verifyAndUnpackResponse(response, execTimeData);
            RestRequest.updateSessionWithStickyHeaders(httpExecutingContext.getSfSession(), response);
            httpExecutingContext.setShouldRetry(false);
            responseDto.setUnpackedCloseableHttpResponse(responseText);
        }
        catch (IOException ex) {
            boolean skipRetriesBecauseOf200 = httpExecutingContext.isSkipRetriesBecauseOf200();
            boolean retryReasonDifferentThan200 = !httpExecutingContext.isShouldRetry() && skipRetriesBecauseOf200;
            httpExecutingContext.setShouldRetry(retryReasonDifferentThan200);
            responseDto.setSavedEx(ex);
        }
    }

    private static void updateSessionWithStickyHeaders(SFBaseSession sfSession, CloseableHttpResponse response) {
        if (sfSession != null && response != null) {
            Map<String, String> responseHeaders = HttpUtil.extractHeadersAsMap(response);
            sfSession.extractAndUpdateStickyHttpHeaders(responseHeaders);
        }
    }

    private static void updateRetryParameters(URIBuilder builder, int retryCount, String lastStatusCodeForRetry, long startTime) {
        builder.setParameter("retryCount", String.valueOf(retryCount));
        builder.setParameter("retryReason", lastStatusCodeForRetry);
        builder.setParameter("clientStartTime", String.valueOf(startTime));
    }

    private static void prepareRetry(HttpRequestBase httpRequest, HttpExecutingContext httpExecutingContext, RetryContextManager retryManager, HttpResponseContextDto dto) throws SnowflakeSQLException {
        RestRequest.logRequestResult(dto.getHttpResponse(), httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed(), dto.getSavedEx());
        long elapsedMilliForLastCall = System.currentTimeMillis() - httpExecutingContext.getStartTimePerRequest();
        if (httpExecutingContext.socketOrConnectTimeoutReached() && String.valueOf(httpRequest.getURI()).contains("login-request")) {
            throw new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, httpExecutingContext.getRetryCount(), true, httpExecutingContext.getElapsedMilliForTransientIssues() / 1000L);
        }
        RestRequest.sleepForBackoffAndPrepareNext(elapsedMilliForLastCall, httpExecutingContext);
        httpExecutingContext.incrementRetryCount();
        httpExecutingContext.setLastStatusCodeForRetry(dto.getHttpResponse() == null ? "0" : String.valueOf(dto.getHttpResponse().getStatusLine().getStatusCode()));
        RetryContextManager.RetryHook retryManagerHook = null;
        if (retryManager != null) {
            retryManagerHook = retryManager.getRetryHook();
            retryManager.getRetryContext().setElapsedTimeInMillis(httpExecutingContext.getElapsedMilliForTransientIssues()).setRetryTimeoutInMillis(httpExecutingContext.getRetryTimeoutInMilliseconds());
        }
        if (retryManagerHook == RetryContextManager.RetryHook.ALWAYS_BEFORE_RETRY) {
            retryManager.executeRetryCallbacks(httpRequest);
        }
        if (httpExecutingContext.getAuthTimeout() > 0L && httpExecutingContext.getElapsedMilliForTransientIssues() >= httpExecutingContext.getAuthTimeout()) {
            throw new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, httpExecutingContext.getRetryCount(), false, httpExecutingContext.getElapsedMilliForTransientIssues() / 1000L);
        }
        int numOfRetryToTriggerTelemetry = TelemetryService.getInstance().getNumOfRetryToTriggerTelemetry();
        if (httpExecutingContext.getRetryCount() == numOfRetryToTriggerTelemetry) {
            TelemetryService.getInstance().logHttpRequestTelemetryEvent(String.format("HttpRequestRetry%dTimes", numOfRetryToTriggerTelemetry), httpRequest, httpExecutingContext.getInjectSocketTimeout(), httpExecutingContext.getCanceling(), httpExecutingContext.isWithoutCookies(), httpExecutingContext.isIncludeRetryParameters(), httpExecutingContext.isIncludeSnowflakeHeaders(), dto.getHttpResponse(), dto.getSavedEx(), httpExecutingContext.getBreakRetryReason(), httpExecutingContext.getRetryTimeout(), httpExecutingContext.getRetryCount(), "58030", ErrorCode.NETWORK_ERROR.getMessageCode());
        }
        dto.setSavedEx(null);
        httpExecutingContext.setSkipRetriesBecauseOf200(false);
        httpRequest.releaseConnection();
    }

    private static void sendTelemetryEvent(HttpRequestBase httpRequest, HttpExecutingContext httpExecutingContext, CloseableHttpResponse response, Exception savedEx) {
        String eventName = response == null ? "NullResponseHttpError" : (response.getStatusLine() == null ? "NullResponseStatusLine" : String.format("HttpError%d", response.getStatusLine().getStatusCode()));
        TelemetryService.getInstance().logHttpRequestTelemetryEvent(eventName, httpRequest, httpExecutingContext.getInjectSocketTimeout(), httpExecutingContext.getCanceling(), httpExecutingContext.isWithoutCookies(), httpExecutingContext.isIncludeRetryParameters(), httpExecutingContext.isIncludeSnowflakeHeaders(), response, savedEx, httpExecutingContext.getBreakRetryReason(), httpExecutingContext.getRetryTimeout(), httpExecutingContext.getRetryCount(), null, 0);
    }

    private static void sleepForBackoffAndPrepareNext(long elapsedMilliForLastCall, HttpExecutingContext context) {
        if (context.getMinBackoffInMillis() > elapsedMilliForLastCall) {
            try {
                logger.debug("{}Retry request {}: sleeping for {} ms", context.getRequestId(), context.getRequestInfoScrubbed(), context.getBackoffInMillis());
                Thread.sleep(context.getBackoffInMillis());
            }
            catch (InterruptedException ex1) {
                logger.debug("{}Backoff sleep before retrying login got interrupted", context.getRequestId());
            }
            context.increaseElapsedMilliForTransientIssues(context.getBackoffInMillis());
            context.setBackoffInMillis(RestRequest.getNewBackoffInMilli(context.getBackoffInMillis(), context.isLoginRequest(), context.getBackoff(), context.getRetryCount(), context.getRetryTimeoutInMilliseconds(), context.getElapsedMilliForTransientIssues()));
        }
    }

    private static void logRequestResult(CloseableHttpResponse response, String requestIdStr, String requestInfoScrubbed, Exception savedEx) {
        if (response != null) {
            logger.debug("{}HTTP response not ok: status code: {}, request: {}", requestIdStr, response.getStatusLine().getStatusCode(), requestInfoScrubbed);
        } else if (savedEx != null) {
            logger.debug("{}Null response for cause: {}, request: {}", requestIdStr, RestRequest.getRootCause(savedEx).getMessage(), requestInfoScrubbed);
        } else {
            logger.debug("{}Null response for request: {}", requestIdStr, requestInfoScrubbed);
        }
    }

    private static void checkForDPoPNonceError(CloseableHttpResponse response) throws IOException {
        ObjectMapper objectMapper;
        JsonNode rootNode;
        JsonNode errorNode;
        String errorResponse = EntityUtils.toString(response.getEntity());
        if (!SnowflakeUtil.isNullOrEmpty(errorResponse) && (errorNode = (rootNode = (objectMapper = ObjectMapperFactory.getObjectMapper()).readTree(errorResponse)).get(ERROR_FIELD_NAME)) != null && errorNode.isValueNode() && errorNode.isTextual() && errorNode.textValue().equals(ERROR_USE_DPOP_NONCE)) {
            throw new SnowflakeUseDPoPNonceException(response.getFirstHeader(DPOP_NONCE_HEADER_NAME).getValue());
        }
    }

    static Exception handlingNotRetryableException(Exception ex, HttpExecutingContext httpExecutingContext) throws SnowflakeSQLLoggedException {
        Exception savedEx = null;
        if (ex instanceof IllegalStateException) {
            throw new SnowflakeSQLLoggedException(null, ErrorCode.INVALID_STATE, ex, ex.getMessage());
        }
        if (RestRequest.isExceptionInGroup(ex, sslExceptions) && !RestRequest.isProtocolVersionError(ex)) {
            String formattedMsg = ex.getMessage() + "\nVerify that the hostnames and portnumbers in SYSTEM$ALLOWLIST are added to your firewall's allowed list.\nTo troubleshoot your connection further, you can refer to this article:\nhttps://docs.snowflake.com/en/user-guide/client-connectivity-troubleshooting/overview";
            Throwable rootCause = RestRequest.getRootCause(ex);
            if (rootCause instanceof SFOCSPException) {
                RestRequest.sendIBOCSPErrorEvent(httpExecutingContext, (SFOCSPException)rootCause);
            }
            throw new SnowflakeSQLLoggedException(null, ErrorCode.NETWORK_ERROR, ex, formattedMsg);
        }
        if (ex instanceof Exception) {
            savedEx = ex;
            long currentMillis = System.currentTimeMillis();
            if (currentMillis - httpExecutingContext.getStartTimePerRequest() > HttpUtil.getSocketTimeout().toMillis()) {
                logger.warn("{}HTTP request took longer than socket timeout {} ms: {} ms", httpExecutingContext.getRequestId(), HttpUtil.getSocketTimeout().toMillis(), currentMillis - httpExecutingContext.getStartTimePerRequest());
            }
            StringWriter sw = new StringWriter();
            savedEx.printStackTrace(new PrintWriter(sw));
            Object[] objectArray = new Object[4];
            objectArray[0] = httpExecutingContext.getRequestId();
            objectArray[1] = httpExecutingContext.getRequestInfoScrubbed();
            objectArray[2] = ex.getLocalizedMessage();
            objectArray[3] = sw::toString;
            logger.debug("{}Exception encountered for: {}, {}, {}", objectArray);
        }
        return ex;
    }

    static boolean isExceptionInGroup(Exception e, Set<Class<?>> group) {
        for (Class<?> clazz : group) {
            if (!clazz.isInstance(e)) continue;
            return true;
        }
        return false;
    }

    static boolean isProtocolVersionError(Exception e) {
        return e.getMessage() != null && e.getMessage().contains("Received fatal alert: protocol_version");
    }

    private static boolean handleCertificateRevoked(Exception savedEx, HttpExecutingContext httpExecutingContext, boolean skipRetrying) {
        if (!skipRetrying && RestRequest.isCertificateRevoked(savedEx)) {
            String msg = "Unknown reason";
            Throwable rootCause = RestRequest.getRootCause(savedEx);
            msg = rootCause.getMessage() != null && !rootCause.getMessage().isEmpty() ? rootCause.getMessage() : msg;
            logger.debug("{}Error response not retryable, " + msg + ", request: {}", httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed());
            EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, msg + ", Request: " + httpExecutingContext.getRequestInfoScrubbed(), false);
            httpExecutingContext.setBreakRetryReason("certificate revoked error");
            httpExecutingContext.setBreakRetryEventName("HttpRequestRetryVertificateRevoked");
            httpExecutingContext.setShouldRetry(false);
            return true;
        }
        return skipRetrying;
    }

    private static boolean handleNonRetryableHttpCode(HttpResponseContextDto dto, HttpExecutingContext httpExecutingContext, boolean skipRetrying) {
        CloseableHttpResponse response = dto.getHttpResponse();
        if (!skipRetrying && RestRequest.isNonRetryableHTTPCode(response, httpExecutingContext.isRetryHTTP403())) {
            String msg = "Unknown reason";
            if (response != null) {
                logger.debug("{}HTTP response code for request {}: {}", httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed(), response.getStatusLine().getStatusCode());
                msg = "StatusCode: " + response.getStatusLine().getStatusCode() + ", Reason: " + response.getStatusLine().getReasonPhrase();
            } else if (dto.getSavedEx() != null) {
                Throwable rootCause = RestRequest.getRootCause(dto.getSavedEx());
                msg = rootCause.getMessage();
            }
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                logger.debug("{}Error response not retryable, " + msg + ", request: {}", httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed());
                EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, msg + ", Request: " + httpExecutingContext.getRequestInfoScrubbed(), false);
            }
            httpExecutingContext.setBreakRetryReason("status code does not need retry");
            httpExecutingContext.setShouldRetry(false);
            httpExecutingContext.setSkipRetriesBecauseOf200(response.getStatusLine().getStatusCode() == 200);
            try {
                if (response == null || response.getStatusLine().getStatusCode() != 200) {
                    logger.error("Error executing request: {}", httpExecutingContext.getRequestInfoScrubbed());
                    if (response != null && response.getStatusLine().getStatusCode() == 400 && response.getEntity() != null) {
                        RestRequest.checkForDPoPNonceError(response);
                    }
                    SnowflakeUtil.logResponseDetails(response, logger);
                    if (response != null) {
                        EntityUtils.consume(response.getEntity());
                    }
                    dto.setSavedEx(new SnowflakeSQLException("58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "HTTP status=" + (response != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : "null response")));
                }
            }
            catch (IOException e) {
                dto.setSavedEx(new SnowflakeSQLException("58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception details: " + e.getMessage()));
            }
            return true;
        }
        return skipRetrying;
    }

    private static void logTelemetryEvent(HttpRequestBase request, CloseableHttpResponse response, Exception savedEx, HttpExecutingContext httpExecutingContext) {
        TelemetryService.getInstance().logHttpRequestTelemetryEvent(httpExecutingContext.getBreakRetryEventName(), request, httpExecutingContext.getInjectSocketTimeout(), httpExecutingContext.getCanceling(), httpExecutingContext.isWithoutCookies(), httpExecutingContext.isIncludeRetryParameters(), httpExecutingContext.isIncludeSnowflakeHeaders(), response, savedEx, httpExecutingContext.getBreakRetryReason(), httpExecutingContext.getRetryTimeout(), httpExecutingContext.getRetryCount(), "58030", ErrorCode.NETWORK_ERROR.getMessageCode());
    }

    private static void sendIBHttpErrorEvent(HttpRequestBase request, CloseableHttpResponse response, HttpExecutingContext httpExecutingContext) {
        SFBaseSession session = httpExecutingContext.getSfSession();
        if (session == null) {
            logger.debug("Not sending telemetry event as the request is sessionless (session is null)", new Object[0]);
            return;
        }
        StatusLine statusLine = response.getStatusLine();
        logger.debug("Preparing telemetry event for HTTP error: {} {}", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        int calculatedErrorNumber = ErrorCode.HTTP_GENERAL_ERROR.getMessageCode() + statusLine.getStatusCode();
        String errorMessage = "HTTP " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase() + ": " + request.getMethod() + " " + request.getURI().getHost() + request.getURI().getPath();
        ObjectNode ibValue = TelemetryUtil.createIBValue(null, "XX000", calculatedErrorNumber, TelemetryField.HTTP_EXCEPTION, errorMessage, null);
        TelemetryData td = TelemetryUtil.buildJobData(ibValue);
        session.getTelemetryClient().addLogToBatch(td);
    }

    private static void sendIBOCSPErrorEvent(HttpExecutingContext httpExecutingContext, SFOCSPException ex) {
        SFBaseSession session = httpExecutingContext.getSfSession();
        if (session == null) {
            return;
        }
        String errorMessage = ex.toString();
        ObjectNode ibValue = TelemetryUtil.createIBValue(null, "XX000", ErrorCode.OCSP_GENERAL_ERROR.getMessageCode(), TelemetryField.OCSP_EXCEPTION, errorMessage, ex.toString());
        TelemetryData td = TelemetryUtil.buildJobData(ibValue);
        session.getTelemetryClient().addLogToBatch(td);
    }

    private static boolean handleMaxRetriesExceeded(HttpExecutingContext httpExecutingContext, boolean skipRetrying) {
        if (!skipRetrying && httpExecutingContext.maxRetriesExceeded()) {
            logger.error("{}Stop retrying as max retries have been reached for request: {}! Max retry count: {}", httpExecutingContext.getRequestId(), httpExecutingContext.getRequestInfoScrubbed(), httpExecutingContext.getMaxRetries());
            httpExecutingContext.setBreakRetryReason("max retries reached");
            httpExecutingContext.setBreakRetryEventName("HttpRequestRetryLimitExceeded");
            httpExecutingContext.setShouldRetry(false);
            return true;
        }
        return skipRetrying;
    }

    private static boolean handleElapsedTimeoutExceeded(HttpExecutingContext httpExecutingContext, boolean skipRetrying) {
        if (!skipRetrying && httpExecutingContext.getRetryTimeoutInMilliseconds() > 0L) {
            long elapsedMilliForLastCall = System.currentTimeMillis() - httpExecutingContext.getStartTimePerRequest();
            httpExecutingContext.increaseElapsedMilliForTransientIssues(elapsedMilliForLastCall);
            if (httpExecutingContext.elapsedTimeExceeded() && httpExecutingContext.moreThanMinRetries()) {
                logger.error("{}Stop retrying since elapsed time due to network issues has reached timeout. Elapsed: {} ms, timeout: {} ms", httpExecutingContext.getRequestId(), httpExecutingContext.getElapsedMilliForTransientIssues(), httpExecutingContext.getRetryTimeoutInMilliseconds());
                httpExecutingContext.setBreakRetryReason("retry timeout");
                httpExecutingContext.setBreakRetryEventName("HttpRequestRetryTimeout");
                httpExecutingContext.setShouldRetry(false);
                return true;
            }
        }
        return skipRetrying;
    }

    private static boolean handleCancelingSignal(HttpExecutingContext httpExecutingContext, boolean skipRetrying) {
        if (!skipRetrying && httpExecutingContext.getCanceling() != null && httpExecutingContext.getCanceling().get()) {
            logger.debug("{}Stop retrying since canceling is requested", httpExecutingContext.getRequestId());
            httpExecutingContext.setBreakRetryReason("canceling is requested");
            httpExecutingContext.setShouldRetry(false);
            return true;
        }
        return skipRetrying;
    }

    private static boolean handleNoRetryFlag(HttpExecutingContext httpExecutingContext, boolean skipRetrying) {
        if (!skipRetrying && httpExecutingContext.isNoRetry()) {
            logger.debug("{}HTTP retry disabled for this request. noRetry: {}", httpExecutingContext.getRequestId(), httpExecutingContext.isNoRetry());
            httpExecutingContext.setBreakRetryReason("retry is disabled");
            httpExecutingContext.resetRetryCount();
            httpExecutingContext.setShouldRetry(false);
            return true;
        }
        return skipRetrying;
    }

    private static boolean shouldSkipRetryWithLoggedReason(HttpRequestBase request, HttpResponseContextDto responseDto, HttpExecutingContext httpExecutingContext) {
        CloseableHttpResponse response = responseDto.getHttpResponse();
        Exception savedEx = responseDto.getSavedEx();
        List<Function> conditions = Arrays.asList(skipRetrying -> RestRequest.handleNoRetryFlag(httpExecutingContext, skipRetrying), skipRetrying -> RestRequest.handleCancelingSignal(httpExecutingContext, skipRetrying), skipRetrying -> RestRequest.handleElapsedTimeoutExceeded(httpExecutingContext, skipRetrying), skipRetrying -> RestRequest.handleMaxRetriesExceeded(httpExecutingContext, skipRetrying), skipRetrying -> RestRequest.handleCertificateRevoked(savedEx, httpExecutingContext, skipRetrying), skipRetrying -> RestRequest.handleNonRetryableHttpCode(responseDto, httpExecutingContext, skipRetrying));
        boolean skipRetrying2 = (Boolean)conditions.stream().reduce(Function::andThen).orElse(Function.identity()).apply(false);
        RestRequest.logTelemetryEvent(request, response, savedEx, httpExecutingContext);
        return skipRetrying2;
    }

    private static String verifyAndUnpackResponse(CloseableHttpResponse response, ExecTimeTelemetryData execTimeData) throws IOException {
        try {
            String string;
            try (StringWriter writer = new StringWriter();){
                execTimeData.setResponseIOStreamStart();
                try (InputStream ins = response.getEntity().getContent();){
                    IOUtils.copy(ins, (Writer)writer, "UTF-8");
                }
                execTimeData.setResponseIOStreamEnd();
                string = writer.toString();
            }
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }
}

