/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.JsonSqlInput;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.StructObjectWrapper;
import net.snowflake.client.core.structs.SQLDataCreationHelper;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeClob;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.TypeReference;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SnowflakeBaseResultSet
implements ResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeBaseResultSet.class);
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    protected SFBaseResultSet sfBaseResultSet;
    protected final Statement statement;
    protected SnowflakeResultSetMetaDataV1 resultSetMetaData = null;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    private int fetchSize = 0;
    protected SFBaseSession session;
    private final SnowflakeResultSetSerializableV1 serializable;
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();

    SnowflakeBaseResultSet(Statement statement) throws SQLException {
        this.statement = statement;
        this.resultSetType = statement.getResultSetType();
        this.resultSetConcurrency = statement.getResultSetConcurrency();
        this.resultSetHoldability = statement.getResultSetHoldability();
        this.session = SnowflakeBaseResultSet.maybeGetSession(statement);
        this.serializable = null;
    }

    private static SFBaseSession maybeGetSession(Statement statement) {
        try {
            return statement.unwrap(SnowflakeStatementV1.class).connection.getSFBaseSession();
        }
        catch (SQLException e) {
            logger.error("Unable to unwrap SnowflakeStatementV1 class to retrieve session. Session is null.", false);
            return null;
        }
    }

    public SnowflakeBaseResultSet(SnowflakeResultSetSerializableV1 resultSetSerializable) throws SQLException {
        this.statement = new SnowflakeStatementV1.NoOpSnowflakeStatementV1();
        this.resultSetType = resultSetSerializable.getResultSetType();
        this.resultSetConcurrency = resultSetSerializable.getResultSetConcurrency();
        this.resultSetHoldability = resultSetSerializable.getResultSetHoldability();
        this.session = null;
        this.serializable = resultSetSerializable;
    }

    protected SnowflakeBaseResultSet() throws SQLException {
        this.resultSetType = 0;
        this.resultSetConcurrency = 0;
        this.resultSetHoldability = 0;
        this.statement = new SnowflakeStatementV1.NoOpSnowflakeStatementV1();
        this.session = null;
        this.serializable = null;
    }

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract boolean isClosed() throws SQLException;

    protected void raiseSQLExceptionIfResultSetIsClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SnowflakeSQLException(ErrorCode.RESULTSET_ALREADY_CLOSED, new Object[0]);
        }
    }

    @Override
    public abstract byte[] getBytes(int var1) throws SQLException;

    public abstract Date getDate(int var1, TimeZone var2) throws SQLException;

    private boolean getGetDateUseNullTimezone() {
        if (this.session != null) {
            return this.session.getGetDateUseNullTimezone();
        }
        if (this.serializable != null) {
            return this.serializable.getGetDateUseNullTimezone();
        }
        return false;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.getDate(columnIndex, this.getGetDateUseNullTimezone() ? null : TimeZone.getDefault());
    }

    @Override
    public abstract Time getTime(int var1) throws SQLException;

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.getTimestamp(columnIndex, (TimeZone)null);
    }

    public abstract Timestamp getTimestamp(int var1, TimeZone var2) throws SQLException;

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        logger.trace("InputStream getAsciiStream(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        logger.trace("InputStream getUnicodeStream(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        logger.trace("InputStream getBinaryStream(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        logger.trace("String getString(String columnLabel)", false);
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        logger.trace("boolean getBoolean(String columnLabel)", false);
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        logger.trace("byte getByte(String columnLabel)", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        logger.trace("short getShort(String columnLabel)", false);
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        logger.trace("int getInt(String columnLabel)", false);
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        logger.trace("long getLong(String columnLabel)", false);
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        logger.trace("float getFloat(String columnLabel)", false);
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        logger.trace("double getDouble(String columnLabel)", false);
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        logger.trace("BigDecimal getBigDecimal(String columnLabel, int scale)", false);
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        logger.trace("byte[] getBytes(String columnLabel)", false);
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        logger.trace("Date getDate(String columnLabel)", false);
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        logger.trace("Time getTime(String columnLabel)", false);
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        logger.trace("Timestamp getTimestamp(String columnLabel)", false);
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        logger.trace("InputStream getAsciiStream(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        logger.trace("InputStream getUnicodeStream(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        logger.trace("InputStream getBinaryStream(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.trace("SQLWarning getWarnings()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.trace("void clearWarnings()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
    }

    @Override
    public String getCursorName() throws SQLException {
        logger.trace("String getCursorName()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.trace("ResultSetMetaData getMetaData()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        logger.trace("Object getObject(String columnLabel)", false);
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        logger.trace("int findColumn(String columnLabel)", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        int columnIndex = this.resultSetMetaData.getColumnIndex(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("Column not found: " + columnLabel, "42703");
        }
        return ++columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        logger.trace("Reader getCharacterStream(int columnIndex)", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        String streamData = this.getString(columnIndex);
        return streamData == null ? null : new StringReader(streamData);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        logger.trace("Reader getCharacterStream(String columnLabel)", false);
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        logger.trace("BigDecimal getBigDecimal(String columnLabel)", false);
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public void beforeFirst() throws SQLException {
        logger.trace("void beforeFirst()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void afterLast() throws SQLException {
        logger.trace("void afterLast()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean first() throws SQLException {
        logger.trace("boolean first()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean last() throws SQLException {
        logger.trace("boolean last()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        logger.trace("boolean absolute(int row)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        logger.trace("boolean relative(int rows)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean previous() throws SQLException {
        logger.trace("boolean previous()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.trace("int getFetchDirection()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.trace("void setFetchDirection(int direction)", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        if (direction != 1000) {
            throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.trace("int getFetchSize()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.trace("void setFetchSize(int rows)", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        this.fetchSize = rows;
    }

    @Override
    public int getType() throws SQLException {
        logger.trace("int getType()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        logger.trace("int getConcurrency()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        logger.trace("boolean rowUpdated()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        logger.trace("boolean rowInserted()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        logger.trace("boolean rowDeleted()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        logger.trace("void updateNull(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        logger.trace("void updateBoolean(int columnIndex, boolean x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        logger.trace("void updateByte(int columnIndex, byte x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        logger.trace("void updateShort(int columnIndex, short x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        logger.trace("void updateInt(int columnIndex, int x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        logger.trace("void updateLong(int columnIndex, long x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        logger.trace("void updateFloat(int columnIndex, float x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        logger.trace("void updateDouble(int columnIndex, double x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        logger.trace("void updateBigDecimal(int columnIndex, BigDecimal x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        logger.trace("void updateString(int columnIndex, String x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        logger.trace("void updateBytes(int columnIndex, byte[] x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        logger.trace("void updateDate(int columnIndex, Date x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        logger.trace("void updateTime(int columnIndex, Time x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        logger.trace("void updateTimestamp(int columnIndex, Timestamp x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.trace("public void updateAsciiStream(int columnIndex, InputStream x, int length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.trace("public void updateBinaryStream(int columnIndex, InputStream x, int length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        logger.trace("public void updateCharacterStream(int columnIndex, Reader x, int length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        logger.trace("public void updateObject(int columnIndex, Object x, int scaleOrLength)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        logger.trace("void updateObject(int columnIndex, Object x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        logger.trace("void updateNull(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        logger.trace("void updateBoolean(String columnLabel, boolean x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        logger.trace("void updateByte(String columnLabel, byte x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        logger.trace("void updateShort(String columnLabel, short x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        logger.trace("void updateInt(String columnLabel, int x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        logger.trace("void updateLong(String columnLabel, long x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        logger.trace("void updateFloat(String columnLabel, float x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        logger.trace("void updateDouble(String columnLabel, double x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        logger.trace("void updateBigDecimal(String columnLabel, BigDecimal x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        logger.trace("void updateString(String columnLabel, String x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        logger.trace("void updateBytes(String columnLabel, byte[] x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        logger.trace("void updateDate(String columnLabel, Date x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        logger.trace("void updateTime(String columnLabel, Time x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        logger.trace("void updateTimestamp(String columnLabel, Timestamp x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.trace("public void updateAsciiStream(String columnLabel, InputStream x, int length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.trace("public void updateBinaryStream(String columnLabel, InputStream x, int length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        logger.trace("public void updateCharacterStream(String columnLabel, Reader reader,int length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        logger.trace("public void updateObject(String columnLabel, Object x, int scaleOrLength)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        logger.trace("void updateObject(String columnLabel, Object x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void insertRow() throws SQLException {
        logger.trace("void insertRow()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateRow() throws SQLException {
        logger.trace("void updateRow()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void deleteRow() throws SQLException {
        logger.trace("void deleteRow()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void refreshRow() throws SQLException {
        logger.trace("void refreshRow()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        logger.trace("void cancelRowUpdates()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        logger.trace("void moveToInsertRow()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        logger.trace("void moveToCurrentRow()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Statement getStatement() throws SQLException {
        logger.trace("Statement getStatement()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        logger.trace("Object getObject(int columnIndex, Map<String, Class<?>> map)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        logger.trace("Ref getRef(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        logger.trace("Blob getBlob(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        logger.trace("Clob getClob(int columnIndex)", false);
        String columnValue = this.getString(columnIndex);
        return columnValue == null ? null : new SnowflakeClob(columnValue);
    }

    @Override
    public java.sql.Array getArray(int columnIndex) throws SQLException {
        logger.trace("Array getArray(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        logger.trace("public Object getObject(String columnLabel, Map<String, Class<?>> map)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        logger.trace("Ref getRef(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        logger.trace("Blob getBlob(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        logger.trace("Clob getClob(String columnLabel)", false);
        String columnValue = this.getString(columnLabel);
        return columnValue == null ? null : new SnowflakeClob(columnValue);
    }

    @Override
    public java.sql.Array getArray(String columnLabel) throws SQLException {
        logger.trace("Array getArray(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        logger.trace("Date getDate(int columnIndex, Calendar cal)", false);
        return this.getDate(columnIndex, cal.getTimeZone());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        logger.trace("Date getDate(String columnLabel, Calendar cal)", false);
        return this.getDate(this.findColumn(columnLabel), cal.getTimeZone());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        logger.trace("Time getTime(int columnIndex, Calendar cal)", false);
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        logger.trace("Time getTime(String columnLabel, Calendar cal)", false);
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        logger.trace("Timestamp getTimestamp(int columnIndex, Calendar cal)", false);
        return this.getTimestamp(columnIndex, cal.getTimeZone());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        logger.trace("Timestamp getTimestamp(String columnLabel, Calendar cal)", false);
        return this.getTimestamp(this.findColumn(columnLabel), cal.getTimeZone());
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        logger.trace("URL getURL(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        logger.trace("URL getURL(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        logger.trace("void updateRef(int columnIndex, Ref x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        logger.trace("void updateRef(String columnLabel, Ref x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        logger.trace("void updateBlob(int columnIndex, Blob x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        logger.trace("void updateBlob(String columnLabel, Blob x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        logger.trace("void updateClob(int columnIndex, Clob x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        logger.trace("void updateClob(String columnLabel, Clob x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateArray(int columnIndex, java.sql.Array x) throws SQLException {
        logger.trace("void updateArray(int columnIndex, Array x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateArray(String columnLabel, java.sql.Array x) throws SQLException {
        logger.trace("void updateArray(String columnLabel, Array x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        logger.trace("RowId getRowId(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        logger.trace("RowId getRowId(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        logger.trace("void updateRowId(int columnIndex, RowId x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        logger.trace("void updateRowId(String columnLabel, RowId x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public int getHoldability() throws SQLException {
        logger.trace("int getHoldability()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetHoldability;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        logger.trace("void updateNString(int columnIndex, String nString)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        logger.trace("void updateNString(String columnLabel, String nString)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        logger.trace("void updateNClob(int columnIndex, NClob nClob)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        logger.trace("void updateNClob(String columnLabel, NClob nClob)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        logger.trace("NClob getNClob(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        logger.trace("NClob getNClob(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        logger.trace("SQLXML getSQLXML(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        logger.trace("SQLXML getSQLXML(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        logger.trace("void updateSQLXML(int columnIndex, SQLXML xmlObject)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        logger.trace("void updateSQLXML(String columnLabel, SQLXML xmlObject)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        logger.trace("String getNString(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        logger.trace("String getNString(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        logger.trace("Reader getNCharacterStream(int columnIndex)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        logger.trace("Reader getNCharacterStream(String columnLabel)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.trace("public void updateNCharacterStream(int columnIndex, Reader x, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.trace("public void updateNCharacterStream(String columnLabel, Reader reader,long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.trace("public void updateAsciiStream(int columnIndex, InputStream x, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.trace("public void updateBinaryStream(int columnIndex, InputStream x, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.trace("public void updateCharacterStream(int columnIndex, Reader x, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.trace("public void updateAsciiStream(String columnLabel, InputStream x, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.trace("public void updateBinaryStream(String columnLabel, InputStream x, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.trace("public void updateCharacterStream(String columnLabel, Reader reader,long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        logger.trace("public void updateBlob(int columnIndex, InputStream inputStream, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        logger.trace("public void updateBlob(String columnLabel, InputStream inputStream,long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.trace("void updateClob(int columnIndex, Reader reader, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.trace("public void updateClob(String columnLabel, Reader reader, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.trace("public void updateNClob(int columnIndex, Reader reader, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.trace("public void updateNClob(String columnLabel, Reader reader, long length)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.trace("void updateNCharacterStream(int columnIndex, Reader x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.trace("public void updateNCharacterStream(String columnLabel, Reader reader)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        logger.trace("void updateAsciiStream(int columnIndex, InputStream x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        logger.trace("void updateBinaryStream(int columnIndex, InputStream x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.trace("void updateCharacterStream(int columnIndex, Reader x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        logger.trace("void updateAsciiStream(String columnLabel, InputStream x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        logger.trace("void updateBinaryStream(String columnLabel, InputStream x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.trace("public void updateCharacterStream(String columnLabel, Reader reader)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        logger.trace("void updateBlob(int columnIndex, InputStream inputStream)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        logger.trace("void updateBlob(String columnLabel, InputStream inputStream)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        logger.trace("void updateClob(int columnIndex, Reader reader)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        logger.trace("void updateClob(String columnLabel, Reader reader)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        logger.trace("void updateNClob(int columnIndex, Reader reader)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        logger.trace("void updateNClob(String columnLabel, Reader reader)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        logger.trace("<T> T getObject(int columnIndex,Class<T> type)", false);
        if (this.resultSetMetaData.isStructuredTypeColumn(columnIndex)) {
            if (SQLData.class.isAssignableFrom(type)) {
                SQLInput sqlInput = SnowflakeUtil.mapSFExceptionToSQLException(() -> {
                    StructObjectWrapper structObjectWrapper = (StructObjectWrapper)this.sfBaseResultSet.getObjectWithoutString(columnIndex);
                    if (structObjectWrapper == null) {
                        return null;
                    }
                    return (SQLInput)structObjectWrapper.getObject();
                });
                if (sqlInput == null) {
                    return null;
                }
                SQLData instance = (SQLData)SQLDataCreationHelper.create(type);
                instance.readSQL(sqlInput, null);
                return (T)instance;
            }
            if (Map.class.isAssignableFrom(type)) {
                Object object = this.getObject(columnIndex);
                if (object == null) {
                    return null;
                }
                if (object instanceof Map) {
                    throw new SQLException("Arrow native struct couldn't be converted to String. To map to SqlData the method getObject(int columnIndex, Class type) should be used");
                }
                try {
                    return (T)OBJECT_MAPPER.readValue((String)object, new TypeReference<Map<Object, Object>>(){});
                }
                catch (JsonProcessingException e) {
                    throw new SQLException("Value couldn't be converted to Map");
                }
            }
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)this.getString(columnIndex);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (T)Byte.valueOf(this.getByte(columnIndex));
        }
        if (Short.class.isAssignableFrom(type)) {
            return (T)Short.valueOf(this.getShort(columnIndex));
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (Long.class.isAssignableFrom(type)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (Float.class.isAssignableFrom(type)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (Double.class.isAssignableFrom(type)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (Date.class.isAssignableFrom(type)) {
            return (T)this.getDate(columnIndex);
        }
        if (Time.class.isAssignableFrom(type)) {
            return (T)this.getTime(columnIndex);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (Period.class.isAssignableFrom(type)) {
            try {
                return (T)this.sfBaseResultSet.getPeriod(columnIndex);
            }
            catch (SFException e) {
                throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
            }
        }
        if (Duration.class.isAssignableFrom(type)) {
            try {
                return (T)this.sfBaseResultSet.getDuration(columnIndex);
            }
            catch (SFException e) {
                throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
            }
        }
        logger.debug("Unsupported type passed to getObject(int columnIndex,Class<T> type): " + type.getName(), new Object[0]);
        throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
    }

    public <T> List<T> getList(int columnIndex, Class<T> type) throws SQLException {
        logger.trace("<T> List<T> getList(int columnIndex, Class<T> type)", false);
        if (!this.resultSetMetaData.isStructuredTypeColumn(columnIndex)) {
            throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
        }
        T[] sqlInputs = this.getArray(columnIndex, type);
        return Arrays.asList(sqlInputs);
    }

    public <T> T[] getArray(int columnIndex, Class<T> type) throws SQLException {
        logger.trace("<T> T[] getArray(int columnIndex, Class<T> type)", false);
        if (!this.resultSetMetaData.isStructuredTypeColumn(columnIndex)) {
            throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
        }
        List<FieldMetadata> fieldMetadataList = this.resultSetMetaData.getColumnFields(columnIndex);
        if (fieldMetadataList.size() != 1) {
            throw new SQLException("Wrong size of fields for array type " + fieldMetadataList.size());
        }
        FieldMetadata fieldMetadata = fieldMetadataList.get(0);
        int columnSubType = fieldMetadata.getType();
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int scale = fieldMetadata.getScale();
        TimeZone tz = this.sfBaseResultSet.getSessionTimeZone();
        java.sql.Array array = this.getArray(columnIndex);
        if (array == null) {
            return null;
        }
        Object[] objects = (Object[])array.getArray();
        Object[] arr = (Object[])Array.newInstance(type, objects.length);
        int counter = 0;
        for (Object value : objects) {
            if (value == null) {
                arr[counter++] = null;
                continue;
            }
            if (type.isAssignableFrom(value.getClass())) {
                arr[counter++] = value;
                continue;
            }
            if (SQLData.class.isAssignableFrom(type)) {
                SQLData instance = (SQLData)SQLDataCreationHelper.create(type);
                SQLInput sqlInput = this.sfBaseResultSet.createSqlInputForColumn(value, objects.getClass(), columnIndex, this.session, fieldMetadata.getFields());
                instance.readSQL(sqlInput, null);
                arr[counter++] = instance;
                continue;
            }
            if (String.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getStringConverter().getString(value, columnType, columnSubType, scale));
                continue;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getBooleanConverter().getBoolean(value, columnType));
                continue;
            }
            if (Byte.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getBytesConverter().getBytes(value, columnType, columnSubType, scale));
                continue;
            }
            if (Short.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getShort(value, columnType));
                continue;
            }
            if (Integer.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getInt(value, columnType));
                continue;
            }
            if (Long.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getLong(value, columnType));
                continue;
            }
            if (Float.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> Float.valueOf(this.sfBaseResultSet.getConverters().getNumberConverter().getFloat(value, columnType)));
                continue;
            }
            if (Double.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getDouble(value, columnType));
                continue;
            }
            if (Date.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().dateStringConverter(this.session).convert((String)value));
                continue;
            }
            if (Time.class.isAssignableFrom(type)) {
                arr[counter++] = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().timeFromStringConverter(this.session).convert((String)value));
                continue;
            }
            if (Timestamp.class.isAssignableFrom(type)) {
                SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().timestampFromStringConverter(columnSubType, columnType, scale, this.session, null, tz).convert((String)value));
                continue;
            }
            if (BigDecimal.class.isAssignableFrom(type)) {
                arr[counter++] = this.getBigDecimal(columnIndex);
                continue;
            }
            logger.debug("Unsupported type passed to getArray(int columnIndex, Class<T> type): " + type.getName(), new Object[0]);
            throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
        }
        return arr;
    }

    public <T> Map<String, T> getMap(int columnIndex, Class<T> type) throws SQLException {
        logger.trace("<T> Map<String, T> getMap(int columnIndex, Class<T> type)", false);
        if (!this.resultSetMetaData.isStructuredTypeColumn(columnIndex)) {
            throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
        }
        List<FieldMetadata> fieldMetadataList = this.resultSetMetaData.getColumnFields(columnIndex);
        if (fieldMetadataList.size() != 2) {
            throw new SQLException("Wrong size of fields metadata for map type " + fieldMetadataList.size());
        }
        FieldMetadata valueFieldMetadata = fieldMetadataList.get(1);
        int columnSubType = valueFieldMetadata.getType();
        int columnType = ColumnTypeHelper.getColumnType(valueFieldMetadata.getType(), this.session);
        int scale = valueFieldMetadata.getScale();
        TimeZone tz = this.sfBaseResultSet.getSessionTimeZone();
        StructObjectWrapper structObjectWrapper = (StructObjectWrapper)SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getObjectWithoutString(columnIndex));
        if (structObjectWrapper == null || structObjectWrapper.getObject() == null) {
            return null;
        }
        Map map = SnowflakeUtil.mapSFExceptionToSQLException(() -> this.prepareMapWithValues(structObjectWrapper.getObject(), type));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (SQLData.class.isAssignableFrom(type)) {
                SQLData instance = (SQLData)SQLDataCreationHelper.create(type);
                SQLInput sqlInput = this.sfBaseResultSet.createSqlInputForColumn(entry.getValue(), structObjectWrapper.getObject().getClass(), columnIndex, this.session, valueFieldMetadata.getFields());
                instance.readSQL(sqlInput, null);
                resultMap.put((String)entry.getKey(), instance);
                continue;
            }
            if (String.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getStringConverter().getString(entry.getValue(), columnType, columnSubType, scale)));
                continue;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getBooleanConverter().getBoolean(entry.getValue(), columnType)));
                continue;
            }
            if (Byte.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getBytesConverter().getBytes(entry.getValue(), columnType, columnSubType, scale)));
                continue;
            }
            if (Short.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getShort(entry.getValue(), columnType)));
                continue;
            }
            if (Integer.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getInt(entry.getValue(), columnType)));
                continue;
            }
            if (Long.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getLong(entry.getValue(), columnType)));
                continue;
            }
            if (Float.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> Float.valueOf(this.sfBaseResultSet.getConverters().getNumberConverter().getFloat(entry.getValue(), columnType))));
                continue;
            }
            if (Double.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getDouble(entry.getValue(), columnType)));
                continue;
            }
            if (BigDecimal.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.getConverters().getNumberConverter().getBigDecimal(entry.getValue(), columnType)));
                continue;
            }
            if (Date.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.convertToDate(entry.getValue(), tz)));
                continue;
            }
            if (Time.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.convertToTime(entry.getValue(), scale)));
                continue;
            }
            if (Timestamp.class.isAssignableFrom(type)) {
                resultMap.put((String)entry.getKey(), SnowflakeUtil.mapSFExceptionToSQLException(() -> this.sfBaseResultSet.convertToTimestamp(entry.getValue(), columnType, columnSubType, tz, scale)));
                continue;
            }
            logger.debug("Unsupported type passed to getObject(int columnIndex,Class<T> type): " + type.getName(), new Object[0]);
            throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
        }
        return resultMap;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        logger.trace("<T> T getObject(String columnLabel,Class<T> type)", false);
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.trace("<T> T unwrap(Class<T> iface)", false);
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.trace("boolean isWrapperFor(Class<?> iface)", false);
        return iface.isInstance(this);
    }

    private <T> Map<String, Object> prepareMapWithValues(Object object, Class<T> type) throws SFException {
        if (object instanceof JsonSqlInput) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            JsonNode jsonNode = ((JsonSqlInput)object).getInput();
            Iterator<String> it = jsonNode.fieldNames();
            while (it.hasNext()) {
                String name = it.next();
                map.put(name, SQLData.class.isAssignableFrom(type) ? jsonNode.get(name) : SnowflakeUtil.getJsonNodeStringValue(jsonNode.get(name)));
            }
            return map;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        throw new SFException(ErrorCode.INVALID_STRUCT_DATA, "Object couldn't be converted to map");
    }
}

