/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import net.snowflake.client.jdbc.internal.amazonaws.util.BinaryUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.TimestampFormat;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.dataformat.cbor.CBORFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.dataformat.cbor.CBORGenerator;

@SdkInternalApi
public class SdkRpcV2CborGenerator
implements StructuredRpcV2CborGenerator {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final int CBOR_TAG_TIMESTAMP = 1;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    private final CBORGenerator generator;
    private final String contentType;

    public SdkRpcV2CborGenerator(CBORFactory factory, String contentType) {
        try {
            this.generator = factory.createGenerator(this.baos);
            this.contentType = contentType;
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
    }

    @Override
    public StructuredRpcV2CborGenerator writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeEndArray() {
        try {
            this.generator.writeEndArray();
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeEndObject() {
        try {
            this.generator.writeEndObject();
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeFieldName(String fieldName) {
        try {
            this.generator.writeFieldName(fieldName);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(String val) {
        try {
            this.generator.writeString(val);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(boolean bool) {
        try {
            this.generator.writeBoolean(bool);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(long val) {
        try {
            this.generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(double val) {
        try {
            this.generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(float val) {
        try {
            this.generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(short val) {
        try {
            this.generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(int val) {
        try {
            this.generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(ByteBuffer bytes) {
        try {
            this.generator.writeBinary(BinaryUtils.copyBytesFrom(bytes));
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(Date date, TimestampFormat timestampFormat) {
        CBORGenerator generator = this.getGenerator();
        try {
            generator.writeTag(1);
            generator.writeNumber((double)date.getTime() / 1000.0);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(BigDecimal value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    @Override
    public StructuredRpcV2CborGenerator writeValue(BigInteger value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
        return this;
    }

    private void close() {
        try {
            this.generator.close();
        }
        catch (IOException e) {
            throw new RpcV2CborGenerationException(e);
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            this.close();
            return this.baos.toByteArray();
        }
        catch (NoSuchMethodError e) {
            throw new RuntimeException("Jackson jackson-core/jackson-dataformat-cbor incompatible library version detected.\n\t\tEnsure the com.fasterxml.jackson.core:jackson-core & com.fasterxml.jackson.dataformat:jackson-dataformat-cbor libraries on your classpath have the same version number\n", e);
        }
    }

    protected CBORGenerator getGenerator() {
        return this.generator;
    }

    public static class RpcV2CborGenerationException
    extends SdkClientException {
        public RpcV2CborGenerationException(Throwable t2) {
            super(t2);
        }
    }
}

