/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.transform;

import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.BucketNotificationConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EventBridgeConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.NotificationConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.transform.EventBridgeConfigurationStaxUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.transform.LambdaConfigurationStaxUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.transform.QueueConfigurationStaxUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.transform.TopicConfigurationStaxUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.transform.StaxUnmarshallerContext;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.XmlUtils;

public class BucketNotificationConfigurationStaxUnmarshaller
implements Unmarshaller<BucketNotificationConfiguration, InputStream> {
    private static final BucketNotificationConfigurationStaxUnmarshaller instance = new BucketNotificationConfigurationStaxUnmarshaller();

    public static BucketNotificationConfigurationStaxUnmarshaller getInstance() {
        return instance;
    }

    private BucketNotificationConfigurationStaxUnmarshaller() {
    }

    @Override
    public BucketNotificationConfiguration unmarshall(InputStream inputStream) throws Exception {
        StaxUnmarshallerContext context = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream));
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        BucketNotificationConfiguration config = new BucketNotificationConfiguration();
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return config;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                Map.Entry<String, NotificationConfiguration> entry;
                if (context.testExpression("TopicConfiguration", targetDepth)) {
                    entry = TopicConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("QueueConfiguration", targetDepth)) {
                    entry = QueueConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("CloudFunctionConfiguration", targetDepth)) {
                    entry = LambdaConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!context.testExpression("EventBridgeConfiguration", targetDepth)) continue;
                EventBridgeConfiguration eventBridgeConfig = EventBridgeConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                config.setEventBridgeConfiguration(eventBridgeConfig);
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return config;
    }
}

