/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api;

import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEObjectType;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSObject;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWK;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWKSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.BadJOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api.ResolveClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api.ResolveClaimsVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.utils.JWTUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public final class ResolveStatement {
    public static final JOSEObjectType JOSE_OBJECT_TYPE = new JOSEObjectType("resolve-response+jwt");
    public static final ContentType CONTENT_TYPE = new ContentType("application", JOSE_OBJECT_TYPE.getType(), new ContentType.Parameter[0]);
    private final SignedJWT statementJWT;
    private final ResolveClaimsSet claimsSet;

    private ResolveStatement(SignedJWT statementJWT, ResolveClaimsSet claimsSet) {
        if (statementJWT == null) {
            throw new IllegalArgumentException("The entity statement must not be null");
        }
        if (JWSObject.State.UNSIGNED.equals((Object)statementJWT.getState())) {
            throw new IllegalArgumentException("The statement is not signed");
        }
        this.statementJWT = statementJWT;
        if (claimsSet == null) {
            throw new IllegalArgumentException("The entity statement claims set must not be null");
        }
        this.claimsSet = claimsSet;
    }

    public SignedJWT getSignedStatement() {
        return this.statementJWT;
    }

    public ResolveClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    public Base64URL verifySignature(JWKSet jwkSet) throws BadJOSEException, JOSEException {
        return JWTUtils.verifySignature(this.statementJWT, JOSE_OBJECT_TYPE, new ResolveClaimsVerifier(), jwkSet);
    }

    public static ResolveStatement sign(ResolveClaimsSet claimsSet, JWK signingJWK) throws JOSEException {
        return ResolveStatement.sign(claimsSet, signingJWK, JWTUtils.resolveSigningAlgorithm(signingJWK));
    }

    public static ResolveStatement sign(ResolveClaimsSet claimsSet, JWK signingJWK, JWSAlgorithm jwsAlg) throws JOSEException {
        try {
            return new ResolveStatement(JWTUtils.sign(signingJWK, jwsAlg, JOSE_OBJECT_TYPE, claimsSet.toJWTClaimsSet()), claimsSet);
        }
        catch (ParseException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static ResolveStatement parse(SignedJWT signedStmt) throws ParseException {
        return new ResolveStatement(signedStmt, new ResolveClaimsSet(JWTUtils.parseSignedJWTClaimsSet(signedStmt)));
    }

    public static ResolveStatement parse(String signedStmtString) throws ParseException {
        try {
            return ResolveStatement.parse(SignedJWT.parse(signedStmtString));
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Invalid resolve statement: " + e.getMessage(), e);
        }
    }
}

