/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.batching;

import net.snowflake.client.jdbc.internal.google.api.gax.batching.AutoValue_DefaultBatchResource;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.BatchResource;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

@AutoValue
abstract class DefaultBatchResource
implements BatchResource {
    DefaultBatchResource() {
    }

    static Builder builder() {
        return new AutoValue_DefaultBatchResource.Builder();
    }

    @Override
    public BatchResource add(BatchResource resource) {
        Preconditions.checkArgument(resource instanceof DefaultBatchResource, "Expect an instance of DefaultBatchResource, got " + resource.getClass());
        DefaultBatchResource defaultResource = (DefaultBatchResource)resource;
        return new AutoValue_DefaultBatchResource.Builder().setElementCount(this.getElementCount() + defaultResource.getElementCount()).setByteCount(this.getByteCount() + defaultResource.getByteCount()).build();
    }

    @Override
    public abstract long getElementCount();

    @Override
    public abstract long getByteCount();

    @Override
    public boolean shouldFlush(long maxElementThreshold, long maxBytesThreshold) {
        return this.getElementCount() > maxElementThreshold || this.getByteCount() > maxBytesThreshold;
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setElementCount(long var1);

        abstract Builder setByteCount(long var1);

        abstract DefaultBatchResource build();
    }
}

