/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.RequestParamsExtractor;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.RequestUrlParamsEncoder;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ResponseObserver;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;

public class HttpJsonServerStreamingRequestParamCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> callable;
    private final RequestUrlParamsEncoder<RequestT> paramsEncoder;

    HttpJsonServerStreamingRequestParamCallable(ServerStreamingCallable<RequestT, ResponseT> callable, RequestParamsExtractor<RequestT> paramsExtractor) {
        this.callable = Preconditions.checkNotNull(callable);
        this.paramsEncoder = new RequestUrlParamsEncoder<RequestT>(Preconditions.checkNotNull(paramsExtractor));
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        ApiCallContext newCallContext = context;
        String encodedHeader = this.paramsEncoder.encode(request);
        if (!encodedHeader.isEmpty()) {
            newCallContext = HttpJsonCallContext.createDefault().nullToSelf(context).withExtraHeaders(ImmutableMap.of("x-goog-request-params", ImmutableList.of(encodedHeader)));
        }
        this.callable.call(request, responseObserver, newCallContext);
    }
}

