/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.HashMap;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Attributes;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.EquivalentAddressGroup;
import net.snowflake.client.jdbc.internal.grpc.InternalLogId;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerRegistry;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.util.GracefulSwitchLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.WeightedTargetLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsAttributes;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsLogger;

final class WrrLocalityLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final GracefulSwitchLoadBalancer switchLb;
    private final LoadBalancerRegistry lbRegistry;

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.lbRegistry = lbRegistry;
        this.switchLb = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("xds-wrr-locality-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        WrrLocalityConfig wrrLocalityConfig = (WrrLocalityConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<String, Integer> localityWeights = new HashMap<String, Integer>();
        for (EquivalentAddressGroup equivalentAddressGroup : resolvedAddresses.getAddresses()) {
            Attributes eagAttrs = equivalentAddressGroup.getAttributes();
            String locality = eagAttrs.get(EquivalentAddressGroup.ATTR_LOCALITY_NAME);
            Integer localityWeight = eagAttrs.get(XdsAttributes.ATTR_LOCALITY_WEIGHT);
            if (locality == null) {
                Status unavailableStatus = Status.UNAVAILABLE.withDescription("wrr_locality error: no locality provided");
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(unavailableStatus)));
                return unavailableStatus;
            }
            if (localityWeight == null) {
                Status unavailableStatus = Status.UNAVAILABLE.withDescription("wrr_locality error: no weight provided for locality " + locality);
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(unavailableStatus)));
                return unavailableStatus;
            }
            if (!localityWeights.containsKey(locality)) {
                localityWeights.put(locality, localityWeight);
                continue;
            }
            if (((Integer)localityWeights.get(locality)).equals(localityWeight)) continue;
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Locality {0} has both weights {1} and {2}, using weight {1}", locality, localityWeights.get(locality), localityWeight);
        }
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> weightedPolicySelections = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (String locality : localityWeights.keySet()) {
            weightedPolicySelections.put(locality, new WeightedTargetLoadBalancerProvider.WeightedPolicySelection((Integer)localityWeights.get(locality), wrrLocalityConfig.childConfig));
        }
        Object object = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig(this.lbRegistry.getProvider("weighted_target_experimental"), new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(weightedPolicySelections));
        return this.switchLb.acceptResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(object).build());
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchLb.handleNameResolutionError(error);
    }

    @Override
    public void shutdown() {
        this.switchLb.shutdown();
    }

    static final class WrrLocalityConfig {
        final Object childConfig;

        WrrLocalityConfig(Object childConfig) {
            this.childConfig = childConfig;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrrLocalityConfig that = (WrrLocalityConfig)o;
            return Objects.equals(this.childConfig, that.childConfig);
        }

        public int hashCode() {
            return Objects.hashCode(this.childConfig);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("childConfig", this.childConfig).toString();
        }
    }
}

