/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.scheduler;

import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.BoundedElasticThreadPerTaskScheduler;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.ReactorThreadFactory;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Scheduler;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.SchedulerState;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;

final class BoundedElasticThreadPerTaskScheduler
implements Scheduler,
SchedulerState.DisposeAwaiter<BoundedServices>,
Scannable {
    static final Logger LOGGER = Loggers.getLogger(BoundedElasticThreadPerTaskScheduler.class);
    final int maxThreads;
    final int maxTasksQueuedPerThread;
    final ThreadFactory factory;
    volatile SchedulerState<BoundedServices> state;
    static final AtomicReferenceFieldUpdater<BoundedElasticThreadPerTaskScheduler, SchedulerState> STATE = AtomicReferenceFieldUpdater.newUpdater(BoundedElasticThreadPerTaskScheduler.class, SchedulerState.class, "state");
    private static final SchedulerState<BoundedServices> INIT = SchedulerState.init(BoundedServices.SHUTDOWN);

    BoundedElasticThreadPerTaskScheduler(int maxThreads, int maxTasksQueuedPerThread, ThreadFactory threadFactory) {
        if (maxThreads <= 0) {
            throw new IllegalArgumentException("maxThreads must be strictly positive, was " + maxThreads);
        }
        if (maxTasksQueuedPerThread <= 0) {
            throw new IllegalArgumentException("maxTasksQueuedPerThread must be strictly positive, was " + maxTasksQueuedPerThread);
        }
        this.maxThreads = maxThreads;
        this.maxTasksQueuedPerThread = maxTasksQueuedPerThread;
        this.factory = threadFactory;
        STATE.lazySet(this, INIT);
    }

    @Override
    public boolean isDisposed() {
        SchedulerState current = this.state;
        return current != INIT && current.currentResource == BoundedServices.SHUTDOWN;
    }

    @Override
    public void init() {
        SchedulerState<BoundedServices> b;
        do {
            SchedulerState a;
            if ((a = this.state) == INIT) continue;
            if (a.currentResource == BoundedServices.SHUTDOWN) {
                throw new IllegalStateException("Initializing a disposed scheduler is not permitted");
            }
            return;
        } while (STATE.compareAndSet(this, INIT, b = SchedulerState.init(new BoundedServices(this))));
    }

    @Override
    @Deprecated
    public void start() {
        throw new UnsupportedOperationException("Use init method instead");
    }

    @Override
    public boolean await(BoundedServices boundedServices, long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!boundedServices.sharedDelayedTasksScheduler.awaitTermination(timeout, timeUnit)) {
            return false;
        }
        for (SequentialThreadPerTaskExecutor bs : boundedServices.activeExecutorsState.array) {
            if (bs.await(timeout, timeUnit)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        SchedulerState previous = this.state;
        if (previous.currentResource == BoundedServices.SHUTDOWN) {
            if (previous.initialResource != null) {
                ((BoundedServices)previous.initialResource).sharedDelayedTasksScheduler.shutdownNow();
                for (SequentialThreadPerTaskExecutor bs : ((BoundedServices)previous.initialResource).activeExecutorsState.array) {
                    bs.shutdown(true);
                }
            }
            return;
        }
        SequentialThreadPerTaskExecutor[] toAwait = ((BoundedServices)previous.currentResource).dispose();
        SchedulerState<BoundedServices> shutDown = SchedulerState.transition((BoundedServices)previous.currentResource, BoundedServices.SHUTDOWN, this);
        STATE.compareAndSet(this, previous, shutDown);
        assert (shutDown.initialResource != null);
        ((BoundedServices)shutDown.initialResource).sharedDelayedTasksScheduler.shutdownNow();
        for (SequentialThreadPerTaskExecutor bs : toAwait) {
            bs.shutdown(true);
        }
    }

    @Override
    public Mono<Void> disposeGracefully() {
        return Mono.defer(() -> {
            SchedulerState previous = this.state;
            if (previous.currentResource == BoundedServices.SHUTDOWN) {
                return previous.onDispose;
            }
            SequentialThreadPerTaskExecutor[] toAwait = ((BoundedServices)previous.currentResource).dispose();
            SchedulerState<BoundedServices> shutDown = SchedulerState.transition((BoundedServices)previous.currentResource, BoundedServices.SHUTDOWN, this);
            STATE.compareAndSet(this, previous, shutDown);
            assert (shutDown.initialResource != null);
            ((BoundedServices)shutDown.initialResource).sharedDelayedTasksScheduler.shutdown();
            for (SequentialThreadPerTaskExecutor bs : toAwait) {
                bs.shutdown(false);
            }
            return shutDown.onDispose;
        });
    }

    @Override
    public Disposable schedule(Runnable task) {
        SequentialThreadPerTaskExecutor picked = ((BoundedServices)this.state.currentResource).pickOrAllocate();
        try {
            return picked.schedule(task, null);
        }
        catch (RejectedExecutionException ex) {
            picked.dispose();
            throw ex;
        }
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        SequentialThreadPerTaskExecutor picked = ((BoundedServices)this.state.currentResource).pickOrAllocate();
        try {
            return picked.schedule(task, delay, unit, null);
        }
        catch (RejectedExecutionException ex) {
            picked.dispose();
            throw ex;
        }
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        SequentialThreadPerTaskExecutor picked = ((BoundedServices)this.state.currentResource).pickOrAllocate();
        try {
            return picked.schedulePeriodically(task, initialDelay, period, unit, null);
        }
        catch (RejectedExecutionException ex) {
            picked.dispose();
            throw ex;
        }
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("boundedElastic").append('(');
        if (this.factory instanceof ReactorThreadFactory) {
            ts.append('\"').append(((ReactorThreadFactory)this.factory).get()).append("\",");
        }
        ts.append("maxThreads=").append(this.maxThreads).append(",maxTasksQueuedPerThread=").append(this.maxTasksQueuedPerThread == Integer.MAX_VALUE ? "unbounded" : Integer.valueOf(this.maxTasksQueuedPerThread));
        return ts.toString();
    }

    int estimateSize() {
        return ((BoundedServices)this.state.currentResource).activeExecutorsState.array.length;
    }

    int estimateRemainingTaskCapacity() {
        if (this.maxTasksQueuedPerThread == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        SequentialThreadPerTaskExecutor[] busyArray = ((BoundedServices)this.state.currentResource).activeExecutorsState.array;
        long numberOfTotalAvailableSlots = 0L;
        for (SequentialThreadPerTaskExecutor state : busyArray) {
            numberOfTotalAvailableSlots += (long)state.numberOfAvailableSlots();
        }
        return (int)Math.min(numberOfTotalAvailableSlots += (long)(this.maxThreads - busyArray.length) * (long)this.maxTasksQueuedPerThread, Integer.MAX_VALUE);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
            return this.isDisposed();
        }
        if (key == Scannable.Attr.BUFFERED) {
            return this.estimateSize();
        }
        if (key == Scannable.Attr.CAPACITY) {
            return this.maxThreads;
        }
        if (key == Scannable.Attr.NAME) {
            return this.toString();
        }
        return null;
    }

    @Override
    public Stream<? extends Scannable> inners() {
        BoundedServices services = (BoundedServices)this.state.currentResource;
        return Stream.of(services.activeExecutorsState.array).filter(obj -> obj != null && obj != BoundedServices.CREATING);
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new SingleThreadExecutorWorker(((BoundedServices)this.state.currentResource).pickOrAllocate());
    }

    static final class BoundedServices {
        private BoundedServices() {
        }

        BoundedServices(BoundedElasticThreadPerTaskScheduler parent) {
        }
    }
}

