/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.scheduler;

import com.dataiku.dss.shadelibazure.reactor.util.annotation.NonNull;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;

class VirtualThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    final ThreadFactory delegate;
    @Nullable
    final BiConsumer<Thread, Throwable> uncaughtExceptionHandler;

    VirtualThreadFactory(String name, boolean inheritThreadLocals, @Nullable BiConsumer<Thread, Throwable> uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.delegate = Thread.ofVirtual().name(name, 1L).uncaughtExceptionHandler(this).inheritInheritableThreadLocals(inheritThreadLocals).factory();
    }

    @Override
    public final Thread newThread(@NonNull Runnable runnable) {
        return this.delegate.newThread(runnable);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.uncaughtExceptionHandler == null) {
            return;
        }
        this.uncaughtExceptionHandler.accept(t, e);
    }
}

