/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation.NettyToAzureCoreHttpHeadersWrapper;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.HttpHeadersAccessHelper;
import com.dataiku.dss.shadelibazure.io.netty.util.AsciiString;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public abstract class NettyAsyncHttpResponseBase
extends HttpResponse {
    private final HttpClientResponse reactorNettyResponse;
    private final HttpHeaders headers;

    NettyAsyncHttpResponseBase(HttpClientResponse reactorNettyResponse, HttpRequest httpRequest, boolean headersEagerlyConverted) {
        super(httpRequest);
        this.reactorNettyResponse = reactorNettyResponse;
        com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaders nettyHeaders = reactorNettyResponse.responseHeaders();
        if (headersEagerlyConverted) {
            this.headers = new HttpHeaders((int)((float)nettyHeaders.size() / 0.75f));
            Iterator<Map.Entry<CharSequence, CharSequence>> nettyHeadersIterator = nettyHeaders.iteratorCharSequence();
            while (nettyHeadersIterator.hasNext()) {
                Map.Entry<CharSequence, CharSequence> next = nettyHeadersIterator.next();
                String value = Objects.toString(next.getValue(), null);
                CharSequence key = next.getKey();
                if (key instanceof AsciiString) {
                    AsciiString asciiString = (AsciiString)key;
                    HttpHeadersAccessHelper.addInternal(this.headers, asciiString.toLowerCase().toString(), asciiString.toString(), value);
                    continue;
                }
                this.headers.add(key.toString(), value);
            }
        } else {
            this.headers = new NettyToAzureCoreHttpHeadersWrapper(nettyHeaders);
        }
    }

    @Override
    public final int getStatusCode() {
        return this.reactorNettyResponse.status().code();
    }

    @Override
    @Deprecated
    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    @Override
    public final String getHeaderValue(HttpHeaderName headerName) {
        return this.headers.getValue(headerName);
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers;
    }
}

