/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public final class AzureSasCredentialPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(AzureSasCredentialPolicy.class);
    private final AzureSasCredential credential;
    private final boolean requireHttps;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext context) {
            HttpRequest httpRequest = context.getHttpRequest();
            if (AzureSasCredentialPolicy.this.requireHttps && !"https".equals(httpRequest.getUrl().getProtocol())) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Shared access signature credentials require HTTPS to prevent leaking the shared access signature."));
            }
            String signature = AzureSasCredentialPolicy.this.credential.getSignature();
            if (signature.startsWith("?")) {
                signature = signature.substring(1);
            }
            String query = httpRequest.getUrl().getQuery();
            String url = httpRequest.getUrl().toString();
            url = query == null || query.isEmpty() ? (url.endsWith("?") ? url + signature : url + "?" + signature) : url + "&" + signature;
            httpRequest.setUrl(url);
        }
    };

    public AzureSasCredentialPolicy(AzureSasCredential credential) {
        this(credential, true);
    }

    public AzureSasCredentialPolicy(AzureSasCredential credential, boolean requireHttps) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credential = credential;
        this.requireHttps = requireHttps;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.inner.process(context, next);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.inner.processSync(context, next);
    }
}

