/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson.JacksonDatabind212;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson.JacksonVersion;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LogLevel;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.MemberNameConverter;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonGetter;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonProperty;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.SerializationConfig;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.util.BeanUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class MemberNameConverterImpl
implements MemberNameConverter {
    private static final ClientLogger LOGGER = new ClientLogger(MemberNameConverterImpl.class);
    private final ObjectMapper mapper;
    final boolean useJackson212;
    private boolean jackson212IsSafe = true;

    MemberNameConverterImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        this.useJackson212 = PackageVersion.VERSION.getMinorVersion() >= 12;
    }

    @Override
    public String convertMemberName(Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return null;
        }
        VisibilityChecker<?> visibilityChecker = this.mapper.getVisibilityChecker();
        if (member instanceof Field) {
            Field f = (Field)member;
            if (f.isAnnotationPresent(JsonIgnore.class) || !visibilityChecker.isFieldVisible(f)) {
                if (f.isAnnotationPresent(JsonProperty.class)) {
                    LOGGER.atInfo().addKeyValue("field", f.getName()).log("Field is annotated with JsonProperty but isn't accessible to JacksonJsonSerializer.");
                }
                return null;
            }
            if (f.isAnnotationPresent(JsonProperty.class)) {
                String propertyName = f.getDeclaredAnnotation(JsonProperty.class).value();
                return CoreUtils.isNullOrEmpty(propertyName) ? f.getName() : propertyName;
            }
            return f.getName();
        }
        if (member instanceof Method) {
            Method m3 = (Method)member;
            if (!MemberNameConverterImpl.verifyGetter(m3) || m3.isAnnotationPresent(JsonIgnore.class) || !visibilityChecker.isGetterVisible(m3)) {
                if (m3.isAnnotationPresent(JsonGetter.class) || m3.isAnnotationPresent(JsonProperty.class)) {
                    LOGGER.atInfo().addKeyValue("method", m3.getName()).log("Method is annotated with either JsonGetter or JsonProperty but isn't accessible to JacksonJsonSerializer.");
                }
                return null;
            }
            String methodNameWithoutJavaBeans = this.removePrefix(m3);
            if (m3.isAnnotationPresent(JsonGetter.class)) {
                String propertyName = m3.getDeclaredAnnotation(JsonGetter.class).value();
                return CoreUtils.isNullOrEmpty(propertyName) ? methodNameWithoutJavaBeans : propertyName;
            }
            if (m3.isAnnotationPresent(JsonProperty.class)) {
                String propertyName = m3.getDeclaredAnnotation(JsonProperty.class).value();
                return CoreUtils.isNullOrEmpty(propertyName) ? methodNameWithoutJavaBeans : propertyName;
            }
            return methodNameWithoutJavaBeans;
        }
        return null;
    }

    private static boolean verifyGetter(Method method) {
        Class<?> returnType = method.getReturnType();
        return method.getParameterCount() == 0 && returnType != Void.TYPE && returnType != Void.class;
    }

    private String removePrefix(Method method) {
        SerializationConfig config = this.mapper.getSerializationConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolve(config, this.mapper.constructType(method.getDeclaringClass()), null);
        AnnotatedMethod annotatedMethod = annotatedClass.findMethod(method.getName(), method.getParameterTypes());
        String annotatedMethodName = annotatedMethod.getName();
        String name = null;
        if (this.useJackson212 && this.jackson212IsSafe) {
            try {
                name = JacksonDatabind212.removePrefix(config, annotatedClass, annotatedMethod, annotatedMethodName);
            }
            catch (Throwable ex) {
                if (ex instanceof LinkageError) {
                    this.jackson212IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, ex);
                }
                throw ex;
            }
        }
        if (name == null) {
            name = MemberNameConverterImpl.removePrefixWithBeanUtils(annotatedMethod);
        }
        return name;
    }

    private static String removePrefixWithBeanUtils(AnnotatedMethod annotatedMethod) {
        return BeanUtil.okNameForGetter(annotatedMethod, false);
    }
}

