/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClientProvider;
import com.dataiku.dss.shadelibazure.com.azure.core.http.ProxyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.HttpUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Header;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.time.Duration;

public final class HttpClientOptions
extends ClientOptions {
    private static final Duration DEFAULT_CONNECTION_IDLE_TIMEOUT = Duration.ofSeconds(60L);
    private static final ClientLogger LOGGER = new ClientLogger(HttpClientOptions.class);
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;
    private Integer maximumConnectionPoolSize;
    private Duration connectionIdleTimeout;
    private Class<? extends HttpClientProvider> httpClientProvider;

    @Override
    public HttpClientOptions setApplicationId(String applicationId) {
        super.setApplicationId(applicationId);
        return this;
    }

    @Override
    public HttpClientOptions setHeaders(Iterable<Header> headers) {
        super.setHeaders(headers);
        return this;
    }

    public HttpClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public HttpClientOptions setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HttpClientOptions setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getConnectTimeout() {
        return HttpUtils.getTimeout(this.connectTimeout, HttpUtils.getDefaultConnectTimeout());
    }

    public HttpClientOptions setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public Duration getWriteTimeout() {
        return HttpUtils.getTimeout(this.writeTimeout, HttpUtils.getDefaultWriteTimeout());
    }

    public HttpClientOptions responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public HttpClientOptions setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public Duration getResponseTimeout() {
        return HttpUtils.getTimeout(this.responseTimeout, HttpUtils.getDefaultResponseTimeout());
    }

    public HttpClientOptions readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpClientOptions setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return HttpUtils.getTimeout(this.readTimeout, HttpUtils.getDefaultReadTimeout());
    }

    public HttpClientOptions setMaximumConnectionPoolSize(Integer maximumConnectionPoolSize) {
        if (maximumConnectionPoolSize != null && maximumConnectionPoolSize <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'maximumConnectionPoolSize' cannot be less than 1."));
        }
        this.maximumConnectionPoolSize = maximumConnectionPoolSize;
        return this;
    }

    public Integer getMaximumConnectionPoolSize() {
        return this.maximumConnectionPoolSize;
    }

    public HttpClientOptions setConnectionIdleTimeout(Duration connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
        return this;
    }

    public Duration getConnectionIdleTimeout() {
        return HttpUtils.getTimeout(this.connectionIdleTimeout, DEFAULT_CONNECTION_IDLE_TIMEOUT);
    }

    public HttpClientOptions setHttpClientProvider(Class<? extends HttpClientProvider> httpClientProvider) {
        this.httpClientProvider = httpClientProvider;
        return this;
    }

    public Class<? extends HttpClientProvider> getHttpClientProvider() {
        return this.httpClientProvider;
    }
}

